/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AzureFile represents an Azure File Service mount on the host and bind mount to the pod.")
public class V1AzureFileVolumeSource {
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_NAME = "secretName";
    @SerializedName(value="secretName")
    private String secretName;
    public static final String SERIALIZED_NAME_SHARE_NAME = "shareName";
    @SerializedName(value="shareName")
    private String shareName;

    public V1AzureFileVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1AzureFileVolumeSource secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @ApiModelProperty(required=true, value="the name of secret that contains Azure Storage Account Name and Key")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public V1AzureFileVolumeSource shareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    @ApiModelProperty(required=true, value="Share Name")
    public String getShareName() {
        return this.shareName;
    }

    public void setShareName(String shareName) {
        this.shareName = shareName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AzureFileVolumeSource v1AzureFileVolumeSource = (V1AzureFileVolumeSource)o;
        return Objects.equals(this.readOnly, v1AzureFileVolumeSource.readOnly) && Objects.equals(this.secretName, v1AzureFileVolumeSource.secretName) && Objects.equals(this.shareName, v1AzureFileVolumeSource.shareName);
    }

    public int hashCode() {
        return Objects.hash(this.readOnly, this.secretName, this.shareName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AzureFileVolumeSource {\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("    shareName: ").append(this.toIndentedString(this.shareName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

