/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1AggregationRule;
import io.kubernetes.client.openapi.models.V1alpha1AggregationRuleBuilder;
import io.kubernetes.client.openapi.models.V1alpha1AggregationRuleFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1ClusterRole;
import io.kubernetes.client.openapi.models.V1alpha1ClusterRoleFluent;
import io.kubernetes.client.openapi.models.V1alpha1PolicyRule;
import io.kubernetes.client.openapi.models.V1alpha1PolicyRuleBuilder;
import io.kubernetes.client.openapi.models.V1alpha1PolicyRuleFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class V1alpha1ClusterRoleFluentImpl<A extends V1alpha1ClusterRoleFluent<A>>
extends BaseFluent<A>
implements V1alpha1ClusterRoleFluent<A> {
    private V1alpha1AggregationRuleBuilder aggregationRule;
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<V1alpha1PolicyRuleBuilder> rules;

    public V1alpha1ClusterRoleFluentImpl() {
    }

    public V1alpha1ClusterRoleFluentImpl(V1alpha1ClusterRole instance) {
        this.withAggregationRule(instance.getAggregationRule());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
    }

    @Override
    @Deprecated
    public V1alpha1AggregationRule getAggregationRule() {
        return this.aggregationRule != null ? this.aggregationRule.build() : null;
    }

    @Override
    public V1alpha1AggregationRule buildAggregationRule() {
        return this.aggregationRule != null ? this.aggregationRule.build() : null;
    }

    @Override
    public A withAggregationRule(V1alpha1AggregationRule aggregationRule) {
        this._visitables.get("aggregationRule").remove(this.aggregationRule);
        if (aggregationRule != null) {
            this.aggregationRule = new V1alpha1AggregationRuleBuilder(aggregationRule);
            this._visitables.get("aggregationRule").add(this.aggregationRule);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAggregationRule() {
        return this.aggregationRule != null;
    }

    @Override
    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> withNewAggregationRule() {
        return new AggregationRuleNestedImpl();
    }

    @Override
    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> withNewAggregationRuleLike(V1alpha1AggregationRule item) {
        return new AggregationRuleNestedImpl(item);
    }

    @Override
    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> editAggregationRule() {
        return this.withNewAggregationRuleLike(this.getAggregationRule());
    }

    @Override
    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> editOrNewAggregationRule() {
        return this.withNewAggregationRuleLike(this.getAggregationRule() != null ? this.getAggregationRule() : new V1alpha1AggregationRuleBuilder().build());
    }

    @Override
    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> editOrNewAggregationRuleLike(V1alpha1AggregationRule item) {
        return this.withNewAggregationRuleLike(this.getAggregationRule() != null ? this.getAggregationRule() : item);
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1alpha1ClusterRoleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1alpha1ClusterRoleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1alpha1ClusterRoleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1alpha1ClusterRoleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1alpha1ClusterRoleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRules(int index, V1alpha1PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();
        }
        V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);
        this._visitables.get("rules").add(index >= 0 ? index : this._visitables.get("rules").size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, V1alpha1PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();
        }
        V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("rules").size()) {
            this._visitables.get("rules").add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(V1alpha1PolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();
        }
        for (V1alpha1PolicyRule item : items) {
            V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<V1alpha1PolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();
        }
        for (V1alpha1PolicyRule item : items) {
            V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(V1alpha1PolicyRule ... items) {
        for (V1alpha1PolicyRule item : items) {
            V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<V1alpha1PolicyRule> items) {
        for (V1alpha1PolicyRule item : items) {
            V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<V1alpha1PolicyRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<V1alpha1PolicyRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            V1alpha1PolicyRuleBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha1PolicyRule> getRules() {
        return V1alpha1ClusterRoleFluentImpl.build(this.rules);
    }

    @Override
    public List<V1alpha1PolicyRule> buildRules() {
        return V1alpha1ClusterRoleFluentImpl.build(this.rules);
    }

    @Override
    public V1alpha1PolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public V1alpha1PolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public V1alpha1PolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public V1alpha1PolicyRule buildMatchingRule(Predicate<V1alpha1PolicyRuleBuilder> predicate) {
        for (V1alpha1PolicyRuleBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<V1alpha1PolicyRuleBuilder> predicate) {
        for (V1alpha1PolicyRuleBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<V1alpha1PolicyRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();
            for (V1alpha1PolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(V1alpha1PolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (V1alpha1PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public V1alpha1ClusterRoleFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public V1alpha1ClusterRoleFluent.RulesNested<A> addNewRuleLike(V1alpha1PolicyRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public V1alpha1ClusterRoleFluent.RulesNested<A> setNewRuleLike(int index, V1alpha1PolicyRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public V1alpha1ClusterRoleFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1alpha1ClusterRoleFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public V1alpha1ClusterRoleFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1alpha1ClusterRoleFluent.RulesNested<A> editMatchingRule(Predicate<V1alpha1PolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.apply(this.rules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ClusterRoleFluentImpl that = (V1alpha1ClusterRoleFluentImpl)o;
        if (this.aggregationRule != null ? !this.aggregationRule.equals(that.aggregationRule) : that.aggregationRule != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public class RulesNestedImpl<N>
    extends V1alpha1PolicyRuleFluentImpl<V1alpha1ClusterRoleFluent.RulesNested<N>>
    implements V1alpha1ClusterRoleFluent.RulesNested<N>,
    Nested<N> {
        private final V1alpha1PolicyRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, V1alpha1PolicyRule item) {
            this.index = index;
            this.builder = new V1alpha1PolicyRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha1PolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1ClusterRoleFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1alpha1ClusterRoleFluent.MetadataNested<N>>
    implements V1alpha1ClusterRoleFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1ClusterRoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class AggregationRuleNestedImpl<N>
    extends V1alpha1AggregationRuleFluentImpl<V1alpha1ClusterRoleFluent.AggregationRuleNested<N>>
    implements V1alpha1ClusterRoleFluent.AggregationRuleNested<N>,
    Nested<N> {
        private final V1alpha1AggregationRuleBuilder builder;

        AggregationRuleNestedImpl(V1alpha1AggregationRule item) {
            this.builder = new V1alpha1AggregationRuleBuilder(this, item);
        }

        AggregationRuleNestedImpl() {
            this.builder = new V1alpha1AggregationRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1ClusterRoleFluentImpl.this.withAggregationRule(this.builder.build());
        }

        @Override
        public N endAggregationRule() {
            return this.and();
        }
    }
}

