/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha1PolicyRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 Role, and will no longer be served in v1.20.")
public class V1alpha1Role
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<V1alpha1PolicyRule> rules = null;

    public V1alpha1Role apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha1Role kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha1Role metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha1Role rules(List<V1alpha1PolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1alpha1Role addRulesItem(V1alpha1PolicyRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1PolicyRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rules holds all the PolicyRules for this Role")
    public List<V1alpha1PolicyRule> getRules() {
        return this.rules;
    }

    public void setRules(List<V1alpha1PolicyRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1Role v1alpha1Role = (V1alpha1Role)o;
        return Objects.equals(this.apiVersion, v1alpha1Role.apiVersion) && Objects.equals(this.kind, v1alpha1Role.kind) && Objects.equals(this.metadata, v1alpha1Role.metadata) && Objects.equals(this.rules, v1alpha1Role.rules);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1Role {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

