/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;

public class ServerAddressHolder {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private int port;
    private String host;
    private Schema schema = Schema.IGNORE;
    private boolean running = false;

    public ServerAddressHolder() {
    }

    public ServerAddressHolder(Schema schema, String host, int port) {
        this.schema = schema;
        this.host = host;
        this.port = port;
    }

    public ServerAddressHolder(ServerAddress addr) {
        this.port = addr.getPort();
        this.host = addr.getHost();
        this.schema = addr.getSchema();
    }

    public ServerAddressHolder(ServerAddressHolder holder) {
        this.port = holder.port;
        this.host = holder.host;
        this.schema = holder.schema;
        this.running = holder.running;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    @JsonIgnore
    public boolean isEphmemeral() {
        return this.port < 0;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    @JsonIgnore
    public ServerAddress getServerAddress() {
        if (this.getPort() < 0) {
            this.setPort(NetUtils.getEphemeralPort());
        }
        return new ServerAddress(this.getSchema(), this.getHost(), this.getPort());
    }

    public static ServerAddress serverAddressFromJson(Object json) {
        ServerAddress result = null;
        if (null != json) {
            try {
                ServerAddressHolder tmp = (ServerAddressHolder)MAPPER.readValue(json.toString(), ServerAddressHolder.class);
                result = new ServerAddress(tmp.getSchema(), tmp.getHost(), tmp.getPort());
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toJson(ServerAddress address) {
        String result = "";
        if (null != address) {
            try {
                ServerAddressHolder tmp = new ServerAddressHolder(address);
                result = MAPPER.writeValueAsString((Object)tmp);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }
}

