/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.registry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistrationResponse;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryClient;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.SubmodelElementsCollectionClient;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DeviceRegistryAasClient
extends SubmodelElementsCollectionClient
implements DeviceRegistryClient {
    public DeviceRegistryAasClient() {
        super("resources", "deviceRegistry", null);
    }

    @Override
    public Set<SubmodelElementCollection> getDevices() {
        Submodel resources = this.getSubmodel();
        if (null != resources) {
            return StreamSupport.stream(resources.submodelElements().spliterator(), false).filter(e -> e instanceof SubmodelElementCollection).map(e -> (SubmodelElementCollection)e).filter(e -> e.getProperty("managedId") != null).collect(Collectors.toSet());
        }
        return new HashSet<SubmodelElementCollection>();
    }

    @Override
    public SubmodelElementCollection getDevice(String resourceId) {
        return this.getDevices().stream().filter(e -> e.getIdShort().equals(resourceId)).findFirst().orElse(null);
    }

    @Override
    public DeviceRegistrationResponse addDevice(String id, String ip) throws ExecutionException {
        DeviceRegistrationResponse result = null;
        if (null != this.getSubmodel()) {
            String json = JsonResultWrapper.fromJson((Object)this.getOperation("addDevice").invoke(new Object[]{id, ip}));
            if (null != json) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    result = (DeviceRegistrationResponse)objectMapper.readValue(json.toString(), DeviceRegistrationResponse.class);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            this.requestRefresh();
        }
        return result;
    }

    @Override
    public void removeDevice(String id) throws ExecutionException {
        if (null != this.getSubmodel()) {
            this.getOperation("removeDevice").invoke(new Object[]{id});
            this.requestRefresh();
        }
    }

    @Override
    public void imAlive(String id) throws ExecutionException {
        if (null != this.getSubmodel()) {
            this.getOperation("imAlive").invoke(new Object[]{id});
        }
    }

    @Override
    public void sendTelemetry(String id, String telemetryData) throws ExecutionException {
        if (null != this.getSubmodel()) {
            this.getOperation("sendTelemetry").invoke(new Object[]{id, telemetryData});
        }
    }
}

