/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.services.environment.AbstractProcessService;
import de.iip_ecosphere.platform.services.environment.GenericMultiTypeServiceImpl;
import de.iip_ecosphere.platform.services.environment.InData;
import de.iip_ecosphere.platform.services.environment.OutData;
import de.iip_ecosphere.platform.services.environment.PythonAsyncProcessService;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.services.WsAdapter;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class PythonWsProcessService
extends PythonAsyncProcessService {
    private int instancePort;
    private long averageResponseTime = 0L;
    private PyWebSocket socket;
    private String networkPortKey;

    public PythonWsProcessService(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
    }

    public PythonWsProcessService(YamlService yaml) {
        super(yaml);
    }

    @Override
    protected void initializeFrom(YamlService yaml) {
        this.networkPortKey = "python_" + Starter.getServiceId(yaml.getId());
        this.instancePort = NetworkManagerFactory.getInstance().obtainPort(this.networkPortKey).getPort();
        super.initializeFrom(yaml);
    }

    @Override
    protected void customizePythonArgs(List<String> pythonArgs) {
        int portIndex = -1;
        int modeIndex = -1;
        for (int i = 0; i < pythonArgs.size(); ++i) {
            if (i + 1 >= pythonArgs.size()) continue;
            if (pythonArgs.get(i).equals("--port")) {
                portIndex = i + 1;
                continue;
            }
            if (!pythonArgs.get(i).equals("--mode")) continue;
            modeIndex = i + 1;
        }
        if (modeIndex < 0) {
            pythonArgs.add("--mode");
            pythonArgs.add("");
            portIndex = pythonArgs.size() - 1;
        }
        if (portIndex < 0) {
            pythonArgs.add("--port");
            pythonArgs.add("");
            portIndex = pythonArgs.size() - 1;
        }
        pythonArgs.set(portIndex, String.valueOf(this.instancePort));
        pythonArgs.set(modeIndex, "WS");
    }

    @Override
    protected void createScanInputThread(Process proc) {
        this.register(AbstractProcessService.redirectIO(proc.getInputStream(), System.out));
        String uri = "ws://localhost:" + this.instancePort;
        try {
            PythonWsProcessService.getLogger().info("Connecting to {}", (Object)uri);
            while (null == this.socket) {
                PyWebSocket tmp = new PyWebSocket(new URI(uri));
                if (tmp.connectBlocking()) {
                    PythonWsProcessService.getLogger().info("Connected to {}", (Object)uri);
                    this.socket = tmp;
                    continue;
                }
                tmp.close();
                TimeUtils.sleep((int)250);
            }
        }
        catch (URISyntaxException e) {
            PythonWsProcessService.getLogger().error("Connecting to {}: {}", (Object)uri, (Object)e.getMessage());
        }
    }

    @Override
    protected ServiceState stop() {
        if (null != this.networkPortKey) {
            NetworkManagerFactory.getInstance().releasePort(this.networkPortKey);
            this.networkPortKey = null;
        }
        this.socket.close();
        return super.stop();
    }

    @Override
    protected void sendToService(String type, Object data) throws ExecutionException {
        block3: {
            if (null != this.socket) {
                try {
                    InData tmp = new InData(type, data);
                    this.socket.send(JsonUtils.toJson((Object)tmp));
                }
                catch (IOException e) {
                    if (this.getState() == ServiceState.STOPPING || this.getState() == ServiceState.STOPPED) break block3;
                    throw new ExecutionException(e);
                }
            }
        }
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(PythonWsProcessService.class);
    }

    @Override
    public long getAvgResponseTime() {
        return this.averageResponseTime;
    }

    private class PyWebSocket
    extends WsAdapter {
        private ObjectMapper objectMapper;

        public PyWebSocket(URI serverUri) {
            super(serverUri, PythonWsProcessService.getLogger());
            this.objectMapper = new ObjectMapper();
        }

        @Override
        protected void onMessage(String message) {
            try {
                OutData data = (OutData)this.objectMapper.readValue(message, OutData.class);
                GenericMultiTypeServiceImpl.OutTypeInfo<?> info = PythonWsProcessService.this.getOutTypeInfo(data.getType());
                info.validateAndIngest(data.getType(), data.getData());
                PythonWsProcessService.this.averageResponseTime = data.getTime();
            }
            catch (IOException e) {
                PythonWsProcessService.getLogger().error("While ingesting result data: {}", (Object)e.getMessage());
            }
        }
    }
}

