/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.ProcessSpec;
import de.iip_ecosphere.platform.support.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class YamlProcess
implements ProcessSpec {
    private String executable;
    private String executablePath;
    private String homePath;
    private String locationKey;
    private List<String> execArg = new ArrayList<String>();
    private List<String> cmdArg = new ArrayList<String>();
    private List<String> artifacts = new ArrayList<String>();
    private boolean started = false;

    @Override
    public List<String> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public void setArtifacts(List<String> artifacts) {
        this.artifacts = artifacts;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    public String getLocationKey() {
        return this.locationKey;
    }

    @Override
    public File getExecutablePath() {
        return YamlProcess.toSubstFilePath(this.executablePath);
    }

    @Override
    public File getHomePath() {
        return YamlProcess.toSubstFilePath(this.homePath);
    }

    protected static String toSubstFileName(String path) {
        String result;
        if (null == path || path.length() == 0) {
            result = null;
        } else {
            result = path.replace("${tmp}", FileUtils.getTempDirectoryPath());
            result = result.replace("${user}", FileUtils.getUserDirectoryPath());
            result = new File(result).toString();
        }
        return result;
    }

    protected static File toSubstFilePath(String path) {
        String tmp = YamlProcess.toSubstFileName(path);
        return null == tmp ? null : new File(tmp);
    }

    @Override
    public List<String> getCmdArg() {
        return this.cmdArg;
    }

    @Override
    public List<String> getExecArg() {
        return this.execArg;
    }

    public List<String> getSubstCmdArg() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.cmdArg) {
            result.add(YamlProcess.toSubstFileName(s));
        }
        return result;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setLocationKey(String locationKey) {
        this.locationKey = locationKey;
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public void setExecutablePath(File executablePath) {
        this.executablePath = null == executablePath ? null : executablePath.toString();
    }

    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }

    public void setHomePath(File home) {
        this.homePath = null == home ? null : home.toString();
    }

    public void setExecArg(List<String> execArg) {
        this.execArg = execArg;
    }

    public void setCmdArg(List<String> cmdArg) {
        this.cmdArg = cmdArg;
    }
}

