/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.testing;

import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.function.Function;

public class DataRecorder {
    public static final Function<Object, String> JSON_FORMATTER = o -> JsonUtils.toJson((Object)o);
    private Function<Object, String> formatter;
    private PrintStream out;
    private boolean emitChannel = true;

    public DataRecorder(String file, Function<Object, String> formatter) {
        this(new File(file), formatter);
    }

    public DataRecorder(File file, Function<Object, String> formatter) {
        if (null != file && null != file.getParentFile()) {
            file.getParentFile().mkdirs();
        }
        this.formatter = null == formatter ? d -> d.toString() : formatter;
        try {
            this.out = new PrintStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            LoggerFactory.getLogger(DataRecorder.class).warn("Cannot open {} for writing. Redirecting to stdout.", (Object)file);
            this.out = System.out;
        }
    }

    public void emitChannel(boolean emitChannel) {
        this.emitChannel = emitChannel;
    }

    public synchronized void record(String channel, Object object) {
        String tmp;
        String string = tmp = null == channel || !this.emitChannel ? "" : channel;
        if (tmp.length() > 0) {
            this.out.print(tmp);
            this.out.print(": ");
        }
        this.out.println(this.formatter.apply(object));
        this.out.flush();
    }

    public void close() {
        if (this.out != System.out) {
            PrintStream tmp = this.out;
            this.out = System.out;
            tmp.close();
        }
    }
}

