/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import java.io.IOException;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.consumer.AbstractConsumerTarget;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.ChannelMessages;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_10.AMQPConnection_0_10;
import org.apache.qpid.server.protocol.v0_10.CreditCreditManager;
import org.apache.qpid.server.protocol.v0_10.FlowCreditManager_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageAcceptCompletionListener;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.Session_0_10;
import org.apache.qpid.server.protocol.v0_10.WindowCreditManager;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcceptMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcquireMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageCreditUnit;
import org.apache.qpid.server.protocol.v0_10.transport.MessageFlowMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.MessageTransfer;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.StateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerTarget_0_10
extends AbstractConsumerTarget<ConsumerTarget_0_10> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerTarget_0_10.class);
    private static final Option[] BATCHED = new Option[]{Option.BATCH};
    private final String _name;
    private final String _targetAddress;
    private final MessageAcceptMode _acceptMode;
    private final MessageAcquireMode _acquireMode;
    private final ServerSession _session;
    private volatile MessageFlowMode _flowMode;
    private volatile FlowCreditManager_0_10 _creditManager;
    private volatile int _deferredMessageCredit;
    private volatile long _deferredSizeCredit;
    private final StateChangeListener<MessageInstance, MessageInstance.EntryState> _unacknowledgedMessageListener = new StateChangeListener<MessageInstance, MessageInstance.EntryState>(){

        public void stateChanged(MessageInstance entry, MessageInstance.EntryState oldState, MessageInstance.EntryState newState) {
            if (this.isConsumerAcquiredStateForThis(oldState) && !this.isConsumerAcquiredStateForThis(newState)) {
                ConsumerTarget_0_10.this.removeUnacknowledgedMessage(entry);
                entry.removeStateChangeListener((StateChangeListener)this);
            }
        }

        private boolean isConsumerAcquiredStateForThis(MessageInstance.EntryState state) {
            return state instanceof MessageInstance.ConsumerAcquiredState && ((MessageInstance.ConsumerAcquiredState)state).getConsumer().getTarget() == ConsumerTarget_0_10.this;
        }
    };
    private final AddMessageDispositionListenerAction _postIdSettingAction;

    public ConsumerTarget_0_10(ServerSession session, String name, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, MessageFlowMode flowMode, FlowCreditManager_0_10 creditManager, Map<String, Object> arguments, boolean multiQueue) {
        super(multiQueue, (AMQPConnection)session.getAMQPConnection());
        this._session = session;
        this._postIdSettingAction = new AddMessageDispositionListenerAction(session);
        this._acceptMode = acceptMode;
        this._acquireMode = acquireMode;
        this._creditManager = creditManager;
        this._flowMode = flowMode;
        this._name = name;
        this._targetAddress = arguments != null && arguments.containsKey("local-address") ? String.valueOf(arguments.get("local-address")) : name;
    }

    public void updateNotifyWorkDesired() {
        AMQPConnection_0_10 amqpConnection = this._session.getAMQPConnection();
        boolean state = !amqpConnection.isTransportBlockedForWriting() && this.getCreditManager().hasCredit();
        this.setNotifyWorkDesired(state);
    }

    public String getName() {
        return this._name;
    }

    public void transportStateChanged() {
        this._creditManager.restoreCredit(0L, 0L);
        this.updateNotifyWorkDesired();
    }

    public void doSend(MessageInstanceConsumer consumer, MessageInstance entry, boolean batch) {
        MessageTransfer xfr;
        MessageTransferMessage msg;
        ServerMessage serverMsg = entry.getMessage();
        MessageProperties messageProps = null;
        MessageConverter converter = null;
        if (serverMsg instanceof MessageTransferMessage) {
            msg = (MessageTransferMessage)serverMsg;
        } else {
            if (!serverMsg.checkValid()) {
                throw new MessageConversionException(String.format("Cannot convert malformed message '%s'", serverMsg));
            }
            converter = MessageConverterRegistry.getConverter(serverMsg.getClass(), MessageTransferMessage.class);
            msg = (MessageTransferMessage)converter.convert(serverMsg, this._session.getAddressSpace());
        }
        DeliveryProperties origDeliveryProps = msg.getHeader() == null ? null : msg.getHeader().getDeliveryProperties();
        messageProps = msg.getHeader() == null ? null : msg.getHeader().getMessageProperties();
        DeliveryProperties deliveryProps = new DeliveryProperties();
        if (origDeliveryProps != null) {
            if (origDeliveryProps.hasDeliveryMode()) {
                deliveryProps.setDeliveryMode(origDeliveryProps.getDeliveryMode());
            }
            if (origDeliveryProps.hasExchange()) {
                deliveryProps.setExchange(origDeliveryProps.getExchange());
            }
            if (origDeliveryProps.hasExpiration()) {
                deliveryProps.setExpiration(origDeliveryProps.getExpiration());
            }
            if (origDeliveryProps.hasPriority()) {
                deliveryProps.setPriority(origDeliveryProps.getPriority());
            }
            if (origDeliveryProps.hasRoutingKey()) {
                deliveryProps.setRoutingKey(origDeliveryProps.getRoutingKey());
            }
            if (origDeliveryProps.hasTimestamp()) {
                deliveryProps.setTimestamp(origDeliveryProps.getTimestamp());
            }
            if (origDeliveryProps.hasTtl()) {
                deliveryProps.setTtl(origDeliveryProps.getTtl());
            }
        }
        deliveryProps.setRedelivered(entry.isRedelivered());
        boolean msgCompressed = messageProps != null && "gzip".equals(messageProps.getContentEncoding());
        QpidByteBuffer bodyBuffer = msg.getBody();
        boolean compressionSupported = this._session.getConnection().getConnectionDelegate().isCompressionSupported();
        if (msgCompressed && !compressionSupported && bodyBuffer != null) {
            QpidByteBuffer uncompressedBuffer = this.inflateIfPossible(bodyBuffer);
            messageProps.setContentEncoding(null);
            bodyBuffer.dispose();
            bodyBuffer = uncompressedBuffer;
        } else if (!msgCompressed && compressionSupported && (messageProps == null || messageProps.getContentEncoding() == null) && bodyBuffer != null && bodyBuffer.remaining() > this._session.getConnection().getMessageCompressionThreshold()) {
            QpidByteBuffer compressedBuffers = this.deflateIfPossible(bodyBuffer);
            if (messageProps == null) {
                messageProps = new MessageProperties();
            }
            messageProps.setContentEncoding("gzip");
            bodyBuffer.dispose();
            bodyBuffer = compressedBuffers;
        }
        Header header = new Header(deliveryProps, messageProps, msg.getHeader() == null ? null : msg.getHeader().getNonStandardProperties());
        MessageTransfer messageTransfer = xfr = batch ? new MessageTransfer(this._name, this._acceptMode, this._acquireMode, header, bodyBuffer, BATCHED) : new MessageTransfer(this._name, this._acceptMode, this._acquireMode, header, bodyBuffer, new Option[0]);
        if (bodyBuffer != null) {
            bodyBuffer.dispose();
            bodyBuffer = null;
        }
        if (this._acceptMode == MessageAcceptMode.NONE && this._acquireMode != MessageAcquireMode.PRE_ACQUIRED) {
            xfr.setCompletionListener(new MessageAcceptCompletionListener(this, consumer, this._session, entry, this._flowMode == MessageFlowMode.WINDOW));
        } else if (this._flowMode == MessageFlowMode.WINDOW) {
            final long messageSize = entry.getMessage().getSize();
            xfr.setCompletionListener(new Method.CompletionListener(){

                @Override
                public void onComplete(Method method) {
                    ConsumerTarget_0_10.this.deferredAddCredit(1, messageSize);
                }
            });
        }
        this._postIdSettingAction.setXfr(xfr);
        this._postIdSettingAction.setAction(null);
        if (this._acquireMode == MessageAcquireMode.PRE_ACQUIRED) {
            entry.incrementDeliveryCount();
        }
        if (this._acceptMode == MessageAcceptMode.EXPLICIT) {
            this._postIdSettingAction.setAction(new ExplicitAcceptDispositionChangeListener(entry, this, consumer));
        } else if (this._acquireMode != MessageAcquireMode.PRE_ACQUIRED) {
            this._postIdSettingAction.setAction(new ImplicitAcceptDispositionChangeListener(entry, this, consumer));
        }
        this._session.sendMessage(xfr, this._postIdSettingAction);
        xfr.dispose();
        if (converter != null) {
            converter.dispose((ServerMessage)msg);
        }
        this._postIdSettingAction.setAction(null);
        this._postIdSettingAction.setXfr(null);
        if (this._acceptMode == MessageAcceptMode.NONE && this._acquireMode == MessageAcquireMode.PRE_ACQUIRED) {
            this.forceDequeue(entry, false);
        } else if (this._acquireMode == MessageAcquireMode.PRE_ACQUIRED) {
            this.addUnacknowledgedMessage(entry);
        }
    }

    void addUnacknowledgedMessage(MessageInstance entry) {
        this._unacknowledgedCount.incrementAndGet();
        this._unacknowledgedBytes.addAndGet(entry.getMessage().getSizeIncludingHeader());
        entry.addStateChangeListener(this._unacknowledgedMessageListener);
    }

    private void removeUnacknowledgedMessage(MessageInstance entry) {
        this._unacknowledgedBytes.addAndGet(-entry.getMessage().getSizeIncludingHeader());
        this._unacknowledgedCount.decrementAndGet();
    }

    private void deferredAddCredit(int deferredMessageCredit, long deferredSizeCredit) {
        this._deferredMessageCredit += deferredMessageCredit;
        this._deferredSizeCredit += deferredSizeCredit;
    }

    public void flushCreditState(boolean strict) {
        if (strict || !this.isSuspended() || this._deferredMessageCredit >= 200 || !(this._creditManager instanceof WindowCreditManager) || ((WindowCreditManager)this._creditManager).getMessageCreditLimit() < 400L) {
            this.restoreCredit(this._deferredMessageCredit, this._deferredSizeCredit);
            this._deferredMessageCredit = 0;
            this._deferredSizeCredit = 0L;
        }
    }

    private void forceDequeue(final MessageInstance entry, final boolean restoreCredit) {
        AutoCommitTransaction dequeueTxn = new AutoCommitTransaction(this._session.getAddressSpace().getMessageStore());
        dequeueTxn.dequeue(entry.getEnqueueRecord(), new ServerTransaction.Action(){

            public void postCommit() {
                if (restoreCredit) {
                    ConsumerTarget_0_10.this.restoreCredit(entry.getMessage());
                }
                entry.delete();
            }

            public void onRollback() {
            }
        });
    }

    void acknowledge(MessageInstanceConsumer consumer, MessageInstance entry) {
        this._session.acknowledge(consumer, this, entry);
    }

    void reject(MessageInstanceConsumer consumer, MessageInstance entry) {
        if (entry.makeAcquisitionUnstealable(consumer)) {
            entry.routeToAlternate(null, null, null);
        }
    }

    void release(MessageInstanceConsumer consumer, MessageInstance entry) {
        if (this.isMaxDeliveryLimitReached(entry)) {
            this.sendToDLQOrDiscard(consumer, entry);
        } else {
            entry.release(consumer);
        }
    }

    private void sendToDLQOrDiscard(MessageInstanceConsumer consumer, MessageInstance entry) {
        TransactionLogResource owningResource;
        final ServerMessage msg = entry.getMessage();
        int requeues = 0;
        if (entry.makeAcquisitionUnstealable(consumer)) {
            requeues = entry.routeToAlternate((Action)new Action<MessageInstance>(){

                public void performAction(MessageInstance requeueEntry) {
                    ConsumerTarget_0_10.this.getEventLogger().message(ChannelMessages.DEADLETTERMSG((Number)msg.getMessageNumber(), (String)requeueEntry.getOwningResource().getName()));
                }
            }, null, null);
        }
        if (requeues == 0 && (owningResource = entry.getOwningResource()) instanceof Queue) {
            Queue queue = (Queue)owningResource;
            MessageDestination alternateBindingDestination = queue.getAlternateBindingDestination();
            if (alternateBindingDestination != null) {
                this.getEventLogger().message(ChannelMessages.DISCARDMSG_NOROUTE((Number)msg.getMessageNumber(), (String)alternateBindingDestination.getName()));
            } else {
                this.getEventLogger().message(ChannelMessages.DISCARDMSG_NOALTEXCH((Number)msg.getMessageNumber(), (String)queue.getName(), (String)msg.getInitialRoutingAddress()));
            }
        }
    }

    protected EventLogger getEventLogger() {
        return this.getSession().getAMQPConnection().getEventLogger();
    }

    private boolean isMaxDeliveryLimitReached(MessageInstance entry) {
        int maxDeliveryLimit = entry.getMaximumDeliveryCount();
        return maxDeliveryLimit > 0 && entry.getDeliveryCount() >= maxDeliveryLimit;
    }

    public boolean allocateCredit(ServerMessage message) {
        boolean creditAllocated = this._creditManager.useCreditForMessage(message.getSize());
        this.updateNotifyWorkDesired();
        return creditAllocated;
    }

    public void restoreCredit(ServerMessage message) {
        this.restoreCredit(1, message.getSize());
    }

    void restoreCredit(int count, long size) {
        this._creditManager.restoreCredit(count, size);
        this.updateNotifyWorkDesired();
    }

    public FlowCreditManager_0_10 getCreditManager() {
        return this._creditManager;
    }

    public void stop() {
        this.getCreditManager().clearCredit();
        this.updateNotifyWorkDesired();
    }

    public void addCredit(MessageCreditUnit unit, long value) {
        FlowCreditManager_0_10 creditManager = this.getCreditManager();
        switch (unit) {
            case MESSAGE: {
                creditManager.addCredit(value, 0L);
                break;
            }
            case BYTE: {
                creditManager.addCredit(0L, value);
            }
        }
        this.updateNotifyWorkDesired();
    }

    public void setFlowMode(MessageFlowMode flowMode) {
        switch (flowMode) {
            case CREDIT: {
                this._creditManager = new CreditCreditManager(0L, 0L);
                break;
            }
            case WINDOW: {
                this._creditManager = new WindowCreditManager(0L, 0L);
                break;
            }
            default: {
                throw new ConnectionScopedRuntimeException("Unknown message flow mode: " + flowMode);
            }
        }
        this._flowMode = flowMode;
        this.updateNotifyWorkDesired();
    }

    public boolean isFlowModeChangeAllowed() {
        return !this._creditManager.hasCredit();
    }

    public void flush() {
        this.flushCreditState(true);
        while (this.sendNextMessage()) {
        }
        this.stop();
    }

    public Session_0_10 getSession() {
        return this._session.getModelObject();
    }

    public boolean isDurable() {
        return false;
    }

    public void noMessagesAvailable() {
    }

    public void flushBatched() {
    }

    public String getTargetAddress() {
        return this._targetAddress;
    }

    public String toString() {
        return "ConsumerTarget_0_10[name=" + this._name + ", session=" + this._session.toLogString() + "]";
    }

    private QpidByteBuffer deflateIfPossible(QpidByteBuffer buffer) {
        try {
            return QpidByteBuffer.deflate((QpidByteBuffer)buffer);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to compress message payload for consumer with gzip, message will be sent as is", (Throwable)e);
            return null;
        }
    }

    private QpidByteBuffer inflateIfPossible(QpidByteBuffer buffer) {
        try {
            return QpidByteBuffer.inflate((QpidByteBuffer)buffer);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to decompress message payload for consumer with gzip, message will be sent as is", (Throwable)e);
            return null;
        }
    }

    static class ExplicitAcceptDispositionChangeListener
    extends AbstractDispositionChangeListener {
        ExplicitAcceptDispositionChangeListener(MessageInstance entry, ConsumerTarget_0_10 target, MessageInstanceConsumer consumer) {
            super(entry, target, consumer);
        }

        @Override
        public void onAccept() {
            this._target.acknowledge(this._consumer, this._entry);
        }

        @Override
        public boolean acquire() {
            boolean acquired = this._entry.acquire(this._consumer);
            if (acquired) {
                this._entry.incrementDeliveryCount();
            }
            return acquired;
        }
    }

    static class ImplicitAcceptDispositionChangeListener
    extends AbstractDispositionChangeListener {
        private static final Logger LOGGER = LoggerFactory.getLogger(ImplicitAcceptDispositionChangeListener.class);

        ImplicitAcceptDispositionChangeListener(MessageInstance entry, ConsumerTarget_0_10 target, MessageInstanceConsumer consumer) {
            super(entry, target, consumer);
        }

        @Override
        public void onAccept() {
            LOGGER.warn("MessageAccept received for message which is using NONE as the accept mode (likely client error)");
        }

        @Override
        public boolean acquire() {
            boolean acquired = this._entry.acquire(this._consumer);
            if (acquired) {
                this._entry.incrementDeliveryCount();
                this._target.addUnacknowledgedMessage(this._entry);
            }
            return acquired;
        }
    }

    static abstract class AbstractDispositionChangeListener
    implements ServerSession.MessageDispositionChangeListener {
        final MessageInstance _entry;
        final ConsumerTarget_0_10 _target;
        final MessageInstanceConsumer _consumer;

        AbstractDispositionChangeListener(MessageInstance entry, ConsumerTarget_0_10 target, MessageInstanceConsumer consumer) {
            this._entry = entry;
            this._target = target;
            this._consumer = consumer;
        }

        @Override
        public final void onRelease(boolean setRedelivered, boolean closing) {
            this._target.release(this._consumer, this._entry);
            if (setRedelivered) {
                this._entry.setRedelivered();
            }
            if (closing || !setRedelivered) {
                this._entry.decrementDeliveryCount();
            }
        }

        @Override
        public final void onReject() {
            this._entry.setRedelivered();
            this._target.reject(this._consumer, this._entry);
        }
    }

    public static class AddMessageDispositionListenerAction
    implements Runnable {
        private final ServerSession _session;
        private MessageTransfer _xfr;
        private ServerSession.MessageDispositionChangeListener _action;

        public AddMessageDispositionListenerAction(ServerSession session) {
            this._session = session;
        }

        public void setXfr(MessageTransfer xfr) {
            this._xfr = xfr;
        }

        public void setAction(ServerSession.MessageDispositionChangeListener action) {
            this._action = action;
        }

        @Override
        public void run() {
            if (this._action != null) {
                this._session.onMessageDispositionChange(this._xfr, this._action);
            }
        }
    }
}

