/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.bundle;

import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;

public class AASBundleDescriptorFactory {
    public static AASDescriptor createAASDescriptor(AASBundle bundle, String aasAggregatorPath) {
        String nHostBasePath = AASBundleDescriptorFactory.normalizeAggregatorPrefix(aasAggregatorPath);
        return AASBundleDescriptorFactory.createAASDescriptorUnchecked(bundle, nHostBasePath);
    }

    private static String normalizeAggregatorPrefix(String aasAggregatorPath) {
        String nHostBasePath = VABPathTools.stripSlashes(aasAggregatorPath);
        if ("shells".equals(VABPathTools.getLastElement(nHostBasePath))) {
            return nHostBasePath;
        }
        return VABPathTools.append(nHostBasePath, "shells");
    }

    private static AASDescriptor createAASDescriptorUnchecked(AASBundle bundle, String nHostBasePath) {
        String endpointId = bundle.getAAS().getIdentification().getId();
        endpointId = VABPathTools.encodePathElement(endpointId);
        String aasBase = VABPathTools.concatenatePaths(nHostBasePath, endpointId, "aas");
        AASDescriptor desc = new AASDescriptor(bundle.getAAS(), aasBase);
        bundle.getSubmodels().stream().forEach(s -> {
            SubmodelDescriptor smDesc = new SubmodelDescriptor((ISubmodel)s, VABPathTools.concatenatePaths(aasBase, "submodels", s.getIdShort(), "submodel"));
            desc.addSubmodelDescriptor(smDesc);
        });
        return desc;
    }
}

