/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.bundle;

import java.util.Collection;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.bundle.AASBundle;
import org.eclipse.basyx.aas.bundle.AASBundleDescriptorFactory;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASBundleHelper {
    private static Logger logger = LoggerFactory.getLogger(AASBundleHelper.class);

    public static boolean integrate(IAASAggregator aggregator, Collection<AASBundle> bundles) {
        if (aggregator == null || bundles == null) {
            throw new RuntimeException("'aggregator' and 'bundles' must not be null.");
        }
        boolean objectUploaded = false;
        for (AASBundle bundle : bundles) {
            IAssetAdministrationShell aas = bundle.getAAS();
            try {
                aggregator.getAAS(aas.getIdentification());
            }
            catch (ResourceNotFoundException e) {
                if (aas instanceof AssetAdministrationShell) {
                    aggregator.createAAS((AssetAdministrationShell)aas);
                    objectUploaded = true;
                }
                throw new RuntimeException("aas Objects in bundles need to be instance of 'AssetAdministrationShell'");
            }
            IModelProvider provider = aggregator.getAASProvider(aas.getIdentification());
            for (ISubmodel sm : bundle.getSubmodels()) {
                try {
                    provider.getValue("/aas/submodels/" + sm.getIdShort() + "/submodel");
                }
                catch (ResourceNotFoundException e) {
                    if (sm instanceof Submodel) {
                        provider.setValue("/aas/submodels/" + sm.getIdShort(), sm);
                        objectUploaded = true;
                        continue;
                    }
                    throw new RuntimeException("sm Objects in bundles need to be instance of 'Submodel'");
                }
            }
        }
        return objectUploaded;
    }

    public static void register(IAASRegistry registry, Collection<AASBundle> bundles, String aasAggregatorPath) {
        bundles.stream().map(b -> AASBundleDescriptorFactory.createAASDescriptor(b, aasAggregatorPath)).forEach(registry::register);
    }

    public static void deregister(IAASRegistry registry, Collection<AASBundle> bundles) {
        if (registry != null && bundles != null) {
            for (AASBundle bundle : bundles) {
                IAssetAdministrationShell aas = bundle.getAAS();
                try {
                    registry.delete(aas.getIdentification());
                }
                catch (ProviderException e) {
                    logger.info("The AAS '" + aas.getIdShort() + "' can't be deregistered. It was not found in registry.");
                }
                for (ISubmodel sm : bundle.getSubmodels()) {
                    try {
                        registry.delete(sm.getIdentification());
                    }
                    catch (ProviderException e) {
                        logger.info("The SM '" + sm.getIdShort() + "' can't be deregistered. It was not found in registry.");
                    }
                }
            }
        }
    }
}

