/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.basyx.extensions.shared.authorization.internal.AuthenticationContextProvider;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ElevatedCodeAuthentication
extends AbstractAuthenticationToken {
    private static final ThreadLocal<Set<ElevatedCodeAuthenticationAreaHandler>> elevatedCodeAuthenticationAreaHandlers = ThreadLocal.withInitial(HashSet::new);
    private static final ThreadLocal<SecurityContext> previousSecurityContext = new ThreadLocal();

    public ElevatedCodeAuthentication() {
        super(Collections.emptyList());
    }

    public Object getCredentials() {
        return null;
    }

    public Object getPrincipal() {
        return null;
    }

    public static boolean isCodeAuthentication() {
        return AuthenticationContextProvider.getAuthentication().map(ElevatedCodeAuthentication.class::isInstance).orElse(false);
    }

    private static void leaveElevatedCodeAuthenticationArea(ElevatedCodeAuthenticationAreaHandler areaHandler) {
        Set<ElevatedCodeAuthenticationAreaHandler> areaHandlers = elevatedCodeAuthenticationAreaHandlers.get();
        if (!areaHandlers.contains(areaHandler)) {
            return;
        }
        areaHandlers.remove(areaHandler);
        if (areaHandlers.isEmpty()) {
            ElevatedCodeAuthentication.unsetElevatedCodeAuthentication();
        }
    }

    public static ElevatedCodeAuthenticationAreaHandler enterElevatedCodeAuthenticationArea() {
        ElevatedCodeAuthenticationAreaHandler handler = new ElevatedCodeAuthenticationAreaHandler();
        elevatedCodeAuthenticationAreaHandlers.get().add(handler);
        ElevatedCodeAuthentication.setElevatedCodeAuthentication();
        return handler;
    }

    private static void setElevatedCodeAuthentication() {
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() instanceof ElevatedCodeAuthentication) {
            return;
        }
        previousSecurityContext.set(SecurityContextHolder.getContext());
        SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
        securityContext.setAuthentication((Authentication)new ElevatedCodeAuthentication());
        SecurityContextHolder.setContext((SecurityContext)securityContext);
    }

    private static void unsetElevatedCodeAuthentication() {
        SecurityContextHolder.clearContext();
        if (previousSecurityContext.get() != null) {
            SecurityContextHolder.setContext((SecurityContext)previousSecurityContext.get());
            previousSecurityContext.remove();
        }
    }

    public static class ElevatedCodeAuthenticationAreaHandler
    implements AutoCloseable {
        @Override
        public void close() {
            ElevatedCodeAuthentication.leaveElevatedCodeAuthenticationArea(this);
        }
    }
}

