/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.authorization;

import java.util.Collection;
import org.eclipse.basyx.extensions.shared.authorization.SecurityContextAuthorizer;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;

public class AuthorizedSubmodelAPI
implements ISubmodelAPI {
    private static final String SCOPE_AUTHORITY_PREFIX = "SCOPE_";
    public static final String READ_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-api:read";
    public static final String WRITE_AUTHORITY = "SCOPE_urn:org.eclipse.basyx:scope:sm-api:write";
    private final SecurityContextAuthorizer authorizer = new SecurityContextAuthorizer();
    private ISubmodelAPI decoratedSubmodelAPI;

    public AuthorizedSubmodelAPI(ISubmodelAPI decoratedSubmodelAPI) {
        this.decoratedSubmodelAPI = decoratedSubmodelAPI;
    }

    @Override
    public ISubmodel getSubmodel() {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAPI.getSubmodel();
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAPI.addSubmodelElement(elem);
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAPI.addSubmodelElement(idShortPath, elem);
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAPI.getSubmodelElement(idShortPath);
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAPI.deleteSubmodelElement(idShortPath);
    }

    @Override
    public Collection<IOperation> getOperations() {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAPI.getOperations();
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAPI.getSubmodelElements();
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(WRITE_AUTHORITY);
        this.decoratedSubmodelAPI.updateSubmodelElement(idShortPath, newValue);
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAPI.getSubmodelElementValue(idShortPath);
    }

    @Override
    public Object invokeOperation(String idShortPath, Object ... params) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAPI.invokeOperation(idShortPath, params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAPI.invokeAsync(idShortPath, params);
    }

    @Override
    public Object getOperationResult(String idShort, String requestId) {
        this.authorizer.throwExceptionInCaseOfInsufficientAuthorization(READ_AUTHORITY);
        return this.decoratedSubmodelAPI.getOperationResult(idShort, requestId);
    }
}

