/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.types.technicaldata.submodelelementcollections.furtherinformation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IMultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.reference.Key;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.types.helper.SubmodelElementRetrievalHelper;

public class FurtherInformation
extends SubmodelElementCollection {
    public static final String IDSHORT = "FurtherInformation";
    public static final Reference SEMANTICID = new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/FurtherInformation/1/1", KeyType.IRI));
    public static final String TEXTSTATEMENTPREFIX = "TextStatement";
    public static final String VALIDDATEID = "ValidDate";

    private FurtherInformation() {
    }

    public FurtherInformation(Property validDate) {
        this(IDSHORT, validDate);
    }

    public FurtherInformation(XMLGregorianCalendar validDate) {
        this(IDSHORT, validDate);
    }

    public FurtherInformation(String idShort, Property validDate) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setValidDate(validDate);
        this.setTextStatements(new ArrayList<MultiLanguageProperty>());
    }

    public FurtherInformation(String idShort, XMLGregorianCalendar validDate) {
        super(idShort);
        this.setSemanticId(SEMANTICID);
        this.setValidDate(validDate);
        this.setTextStatements(new ArrayList<MultiLanguageProperty>());
    }

    public static FurtherInformation createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!FurtherInformation.isValid(obj)) {
            throw new MetamodelConstructionException(FurtherInformation.class, obj);
        }
        FurtherInformation furtherInformation = new FurtherInformation();
        furtherInformation.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return furtherInformation;
    }

    private static FurtherInformation createAsFacadeNonStrict(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        FurtherInformation furtherInformation = new FurtherInformation();
        furtherInformation.setMap(SubmodelElementMapCollectionConverter.mapToSmECollection(obj));
        return furtherInformation;
    }

    public static boolean isValid(Map<String, Object> obj) {
        FurtherInformation furtherInformation = FurtherInformation.createAsFacadeNonStrict(obj);
        return SubmodelElementCollection.isValid(obj) && Property.isValid((Map)((Object)furtherInformation.getValidDate()));
    }

    public void setTextStatements(List<MultiLanguageProperty> statements) {
        if (statements != null && statements.size() > 0) {
            for (MultiLanguageProperty statement : statements) {
                this.addSubmodelElement(statement);
            }
        }
    }

    public List<IMultiLanguageProperty> getStatements() {
        ArrayList<IMultiLanguageProperty> ret = new ArrayList<IMultiLanguageProperty>();
        List<ISubmodelElement> elements = SubmodelElementRetrievalHelper.getSubmodelElementsByIdPrefix(TEXTSTATEMENTPREFIX, this.getSubmodelElements());
        for (ISubmodelElement element : elements) {
            ret.add(MultiLanguageProperty.createAsFacade((Map)((Object)element)));
        }
        return ret;
    }

    public void setValidDate(Property validDate) {
        this.addSubmodelElement(validDate);
    }

    public void setValidDate(XMLGregorianCalendar validDate) {
        Property validDateProp = new Property(VALIDDATEID, ValueType.DateTime);
        validDateProp.setSemanticId(new Reference(new Key(KeyElements.CONCEPTDESCRIPTION, false, "https://admin-shell.io/ZVEI/TechnicalData/ValidDate/1/1", IdentifierType.IRI)));
        validDateProp.setValue(validDate);
        this.setValidDate(validDateProp);
    }

    public IProperty getValidDate() {
        return Property.createAsFacade((Map)((Object)this.getSubmodelElement(VALIDDATEID)));
    }
}

