/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.types;

import java.math.BigInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;

public final class UnsignedLong {
    public static final BigInteger MIN_VALUE = ULong.MIN_VALUE;
    public static final BigInteger MAX_VALUE = ULong.MAX_VALUE;
    public static final UnsignedLong MIN = new UnsignedLong(ULong.MIN);
    public static final UnsignedLong MAX = new UnsignedLong(ULong.MAX);
    private final ULong value;

    public UnsignedLong(long value) throws NumberFormatException {
        this.value = ULong.valueOf((long)value);
    }

    public UnsignedLong(BigInteger value) throws NumberFormatException {
        this.value = ULong.valueOf((BigInteger)value);
    }

    public UnsignedLong(String value) throws NumberFormatException {
        this.value = ULong.valueOf((String)value);
    }

    public UnsignedLong(ULong value) {
        this.value = value;
    }

    public ULong getInternalValue() {
        return this.value;
    }

    public UnsignedLong add(UnsignedLong other) throws NumberFormatException {
        return new UnsignedLong(this.value.add(other.toLong()));
    }

    public UnsignedLong add(long other) throws NumberFormatException {
        return new UnsignedLong(this.value.add(other));
    }

    public UnsignedLong subtract(UnsignedLong other) throws NumberFormatException {
        return new UnsignedLong(this.value.subtract(other.toLong()));
    }

    public UnsignedLong subtract(long other) throws NumberFormatException {
        return new UnsignedLong(this.value.subtract(other));
    }

    public long toLong() {
        return this.value.longValue();
    }

    public BigInteger toBigInteger() {
        return this.value.toBigInteger();
    }
}

