/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.registry.proxy;

import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.eclipse.basyx.vab.protocol.https.HTTPSConnector;
import org.eclipse.basyx.vab.registry.api.IVABRegistryService;

public class VABRegistryProxy
implements IVABRegistryService {
    protected IModelProvider provider;

    public VABRegistryProxy(String directoryUrl) {
        this(VABRegistryProxy.getJSONConnectorWithProtocol(directoryUrl));
    }

    protected static boolean isHTTPSUrl(String url) {
        return url.toLowerCase().startsWith("https");
    }

    private static VABElementProxy getJSONConnectorWithProtocol(String directoryUrl) {
        if (VABRegistryProxy.isHTTPSUrl(directoryUrl)) {
            return new VABElementProxy("", new JSONConnector(new HTTPSConnector(directoryUrl)));
        }
        return new VABElementProxy("", new JSONConnector(new HTTPConnector(directoryUrl)));
    }

    public VABRegistryProxy(IModelProvider provider) {
        this.provider = provider;
    }

    @Override
    public IVABRegistryService addMapping(String key, String value) {
        this.provider.createValue(key, value);
        return this;
    }

    @Override
    public void removeMapping(String key) {
        this.provider.deleteValue(key);
    }

    @Override
    public String lookup(String id) {
        Object response = this.provider.getValue(id);
        if (response instanceof String) {
            return (String)response;
        }
        throw new ProviderException("Lookup returned unexpected object: " + response);
    }
}

