/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;

public class WorkerAasCreator {
    public static final String URN_AAS = "urn:::AAS:::WorkerK8SAas#";
    public static final String AAS_NAME = "WorkerK8SAas";
    public static final String AAS_SUBMODEL_NAME = "WorkerK8SAasService";
    public static final String AAS_SUBMODEL_PROPERTY_NAME = "name";
    public static final String AAS_SUBMODEL_PROPERTY_VERSION = "version";
    public static final String AAS_SUBMODEL_PROPERTY_DESCRIPTION = "description";
    public static final String AAS_SUBMODEL_OPERATION_SEND_TO_AAS = "sendToAAS";
    public static final String AAS_SUBMODEL_OPERATION_SEND_WATCH_TO_AAS = "sendWatchToAAS";
    public static final String VAB_PROPERTY_NAME = "name";
    public static final String VAB_PROPERTY_VERSION = "version";
    public static final String VAB_PROPERTY_DESCRIPTION = "description";
    public static final String VAB_OPERATION_SEND_TO_AAS = "sendToAAS";
    public static final String VAB_OPERATION_SEND_WATCH_TO_AAS = "sendWatchToAAS";

    public static Aas createAas(ServerAddress addr) {
        AasFactory factory = AasFactory.getInstance();
        InvocablesCreator iCreator = factory.createInvocablesCreator((SetupSpec)new BasicSetupSpec("", addr.getHost(), addr.getPort()));
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(AAS_NAME, URN_AAS);
        Submodel.SubmodelBuilder smBuilder = aasBuilder.createSubmodelBuilder(AAS_SUBMODEL_NAME, null);
        smBuilder.createPropertyBuilder("name").setType(Type.STRING).bind(iCreator.createGetter("name"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("version").setType(Type.STRING).bind(iCreator.createGetter("version"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("description").setType(Type.STRING).bind(iCreator.createGetter("description"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createOperationBuilder("sendToAAS").setInvocable(iCreator.createInvocable("sendToAAS")).build();
        smBuilder.createOperationBuilder("sendWatchToAAS").setInvocable(iCreator.createInvocable("sendWatchToAAS")).build();
        smBuilder.build();
        return (Aas)aasBuilder.build();
    }
}

