/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.server.logging.LogFileDetails;
import org.apache.qpid.server.logging.logback.AbstractBrokerLogger;
import org.apache.qpid.server.logging.logback.AppenderUtils;
import org.apache.qpid.server.logging.logback.BrokerFileLogger;
import org.apache.qpid.server.logging.logback.BrokerLoggerStatusListener;
import org.apache.qpid.server.logging.logback.FileLoggerSettings;
import org.apache.qpid.server.logging.logback.RollingPolicyDecorator;
import org.apache.qpid.server.logging.logback.RolloverWatcher;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.util.DaemonThreadFactory;

public class BrokerFileLoggerImpl
extends AbstractBrokerLogger<BrokerFileLoggerImpl>
implements BrokerFileLogger<BrokerFileLoggerImpl>,
FileLoggerSettings {
    private volatile RolloverWatcher _rolloverWatcher;
    private ScheduledExecutorService _rolledPolicyExecutor;
    @ManagedAttributeField
    private String _layout;
    @ManagedAttributeField
    private String _fileName;
    @ManagedAttributeField
    private boolean _rollDaily;
    @ManagedAttributeField
    private boolean _rollOnRestart;
    @ManagedAttributeField
    private boolean _compressOldFiles;
    @ManagedAttributeField
    private int _maxHistory;
    @ManagedAttributeField
    private int _maxFileSize;
    private StatusManager _statusManager;
    private StatusListener _logbackStatusListener;

    @ManagedObjectFactoryConstructor
    protected BrokerFileLoggerImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    protected void postResolveChildren() {
        this._rolloverWatcher = new RolloverWatcher(this.getFileName());
        this._rolledPolicyExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("RolledFileScanner-" + this.getName()));
        super.postResolveChildren();
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        BrokerFileLogger brokerFileLogger = (BrokerFileLogger)proxyForValidation;
        if (changedAttributes.contains("fileName") && brokerFileLogger.getFileName() != null) {
            AppenderUtils.validateLogFilePermissions(new File(brokerFileLogger.getFileName()));
        }
        if (changedAttributes.contains("maxFileSize")) {
            AppenderUtils.validateMaxFileSize(brokerFileLogger.getMaxFileSize());
        }
    }

    @Override
    public String getFileName() {
        return this._fileName;
    }

    @Override
    public boolean isRollDaily() {
        return this._rollDaily;
    }

    @Override
    public boolean isRollOnRestart() {
        return this._rollOnRestart;
    }

    @Override
    public boolean isCompressOldFiles() {
        return this._compressOldFiles;
    }

    @Override
    public int getMaxHistory() {
        return this._maxHistory;
    }

    @Override
    public int getMaxFileSize() {
        return this._maxFileSize;
    }

    @Override
    public String getLayout() {
        return this._layout;
    }

    @Override
    public List<LogFileDetails> getLogFiles() {
        return this._rolloverWatcher == null ? Collections.emptyList() : this._rolloverWatcher.getLogFileDetails();
    }

    @Override
    public Content getFile(String fileName) {
        return this._rolloverWatcher == null ? null : this._rolloverWatcher.getFileContent(fileName);
    }

    @Override
    public Content getFiles(@Param(name="fileName") Set<String> fileName) {
        return this._rolloverWatcher == null ? null : this._rolloverWatcher.getFilesAsZippedContent(fileName);
    }

    @Override
    public Content getAllFiles() {
        return this._rolloverWatcher == null ? null : this._rolloverWatcher.getAllFilesAsZippedContent();
    }

    @Override
    public void stopLogging() {
        super.stopLogging();
        if (this._rolledPolicyExecutor != null) {
            this._rolledPolicyExecutor.shutdown();
        }
    }

    @Override
    public RollingPolicyDecorator.RolloverListener getRolloverListener() {
        return this._rolloverWatcher;
    }

    @Override
    public ScheduledExecutorService getExecutorService() {
        return this._rolledPolicyExecutor;
    }

    @Override
    protected Appender<ILoggingEvent> createAppenderInstance(Context loggerContext) {
        SystemConfig systemConfig = (SystemConfig)this.getAncestor(SystemConfig.class);
        this._logbackStatusListener = new BrokerLoggerStatusListener(this, systemConfig, "broker.failOnLoggerIOError", IOException.class, IOError.class);
        this._statusManager = loggerContext.getStatusManager();
        this._statusManager.add(this._logbackStatusListener);
        RollingFileAppender appender = new RollingFileAppender();
        AppenderUtils.configureRollingFileAppender(this, loggerContext, (RollingFileAppender<ILoggingEvent>)appender);
        return appender;
    }

    protected ListenableFuture<Void> onClose() {
        this.onCloseOrDelete();
        return Futures.immediateFuture(null);
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        this.onCloseOrDelete();
        return super.onDelete();
    }

    private void onCloseOrDelete() {
        if (this._statusManager != null) {
            this._statusManager.remove(this._logbackStatusListener);
        }
    }
}

