/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;

public class Endpoint
extends ServerAddress {
    private static final long serialVersionUID = 2104143979371261063L;
    private String endpoint;

    public Endpoint(Schema schema, String endpoint) {
        super(schema);
        this.endpoint = Endpoint.checkEndpoint(endpoint);
    }

    public Endpoint(Schema schema, int port, String endpoint) {
        super(schema, port);
        this.endpoint = Endpoint.checkEndpoint(endpoint);
    }

    public Endpoint(Schema schema, String host, int port, String endpoint) {
        super(schema, host, port);
        this.endpoint = Endpoint.checkEndpoint(endpoint);
    }

    public Endpoint(ServerAddress server, String endpoint) {
        super(server.getSchema(), server.getHost(), server.getPort());
        this.endpoint = Endpoint.checkEndpoint(endpoint);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String toUri() {
        return super.toUri() + this.endpoint;
    }

    public static String checkEndpoint(String endpoint) {
        if (null == endpoint) {
            endpoint = "";
        }
        if (endpoint.length() > 0 && !endpoint.startsWith("/")) {
            endpoint = "/" + endpoint;
        }
        return endpoint;
    }

    @Override
    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof Endpoint) {
            Endpoint o = (Endpoint)other;
            result = super.equals(other) && this.endpoint.equals(o.endpoint);
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.endpoint.hashCode();
    }

    public static Endpoint valueOf(String uri) {
        try {
            URI u = new URI(uri);
            Schema schema = Schema.valueOf(u.getScheme().toUpperCase());
            return new Endpoint(schema, u.getHost(), u.getPort(), u.getPath());
        }
        catch (IllegalArgumentException | NullPointerException | URISyntaxException e) {
            LoggerFactory.getLogger(Endpoint.class).error("Cannot construct endpoint for {}: {}", (Object)uri, (Object)e.getMessage());
            return null;
        }
    }
}

