/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.json;

import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.json.JsonArrayBuilder;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonObjectBuilder;
import de.iip_ecosphere.platform.support.json.JsonProviderDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Json {
    private static Json prototype = PluginManager.getPluginInstance(Json.class, JsonProviderDescriptor.class);

    public static Json createInstance() {
        return prototype.createInstanceImpl();
    }

    public static void setPrototype(Json json) {
        if (null != json) {
            prototype = json;
        }
    }

    protected abstract Json createInstanceImpl();

    public abstract String toJson(Object var1) throws IOException;

    public abstract <R> R fromJson(Object var1, Class<R> var2) throws IOException;

    public abstract <R> List<R> listFromJson(Object var1, Class<R> var2);

    public abstract <K, V> Map<K, V> mapFromJson(Object var1, Class<K> var2, Class<K> var3);

    public abstract <T> T readValue(String var1, Class<T> var2) throws IOException;

    public abstract <T> T readValue(byte[] var1, Class<T> var2) throws IOException;

    public abstract byte[] writeValueAsBytes(Object var1) throws IOException;

    public abstract <T> T convertValue(Object var1, Class<T> var2) throws IllegalArgumentException;

    public static String toJsonDflt(Object obj) throws IOException {
        return prototype.toJson(obj);
    }

    public static <R> R fromJsonDflt(Object json, Class<R> cls) throws IOException {
        return prototype.fromJson(json, cls);
    }

    public static <R> List<R> listFromJsonDflt(Object json, Class<R> cls) {
        return prototype.listFromJson(json, cls);
    }

    public static <K, V> Map<K, V> mapFromJsonDflt(Object json, Class<K> keyCls, Class<K> valueCls) {
        return prototype.mapFromJson(json, keyCls, valueCls);
    }

    public abstract Json configureFor(Class<?> var1);

    public abstract Json handleIipDataClasses();

    public abstract Json defineOptionals(Class<?> var1, String ... var2);

    public abstract Json defineFields(String ... var1);

    public abstract Json exceptFields(String ... var1);

    public abstract Json filterAllExceptFields(String ... var1);

    public abstract Json failOnUnknownProperties(boolean var1);

    public <T> EnumMapping<T> createEnumMapping(Class<T> type) {
        return this.createEnumMapping(type, null);
    }

    public abstract <T> EnumMapping<T> createEnumMapping(Class<T> var1, Map<String, T> var2);

    public abstract Json declareEnums(EnumMapping<?> ... var1);

    public abstract Json configureLazy(Set<Object> var1);

    public abstract <T> IOIterator<T> createIterator(InputStream var1, Class<T> var2) throws IOException;

    public static JsonObject createObject(String string) throws IOException {
        return Json.createObject(new StringReader(string));
    }

    public static JsonObject createObject(Reader reader) throws IOException {
        return prototype.createObjectImpl(reader);
    }

    protected abstract JsonObject createObjectImpl(Reader var1) throws IOException;

    public static JsonObjectBuilder createObjectBuilder() {
        return prototype.createObjectBuilderImpl();
    }

    protected abstract JsonObjectBuilder createObjectBuilderImpl();

    public static JsonArrayBuilder createArrayBuilder() {
        return prototype.createArrayBuilderImpl();
    }

    protected abstract JsonArrayBuilder createArrayBuilderImpl();

    protected abstract JsonIterator parseImpl(String var1);

    protected abstract JsonIterator parseImpl(byte[] var1);

    public static JsonIterator parse(String text) {
        return prototype.parseImpl(text);
    }

    public static JsonIterator parse(byte[] data) {
        return prototype.parseImpl(data);
    }

    public static interface EnumMapping<T> {
        public void addMapping(String var1, T var2);

        public Class<T> getType();
    }
}

