/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.ChildFirstURLClassLoader;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;

public class URLPluginSetupDescriptor
implements PluginSetupDescriptor {
    private URL[] urls;

    public URLPluginSetupDescriptor(URL[] urls) {
        this.urls = urls;
    }

    public static URL[] toURL(String ... urls) throws IllegalArgumentException {
        URL[] result = new URL[urls.length];
        for (int u = 0; u < urls.length; ++u) {
            result[u] = NetUtils.createURL(urls[u]);
        }
        return result;
    }

    public static URL[] toURLSafe(String ... urls) {
        URL[] result;
        try {
            result = URLPluginSetupDescriptor.toURL(urls);
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(URLPluginSetupDescriptor.class).error("While converting URLs {}: {} Ignoring.", (Object)urls, (Object)e.getMessage());
            result = new URL[]{};
        }
        return result;
    }

    public static URL[] toURL(File ... files) throws MalformedURLException {
        URL[] result = new URL[files.length];
        for (int u = 0; u < files.length; ++u) {
            result[u] = files[u].toURI().toURL();
        }
        return result;
    }

    public static URL[] toURLSafe(File ... files) {
        URL[] result;
        try {
            result = URLPluginSetupDescriptor.toURL(files);
        }
        catch (MalformedURLException e) {
            LoggerFactory.getLogger(URLPluginSetupDescriptor.class).error("While converting URLs {}: {} Ignoring.", (Object)files, (Object)e.getMessage());
            result = new URL[]{};
        }
        return result;
    }

    @Override
    public ClassLoader createClassLoader(ClassLoader parent) {
        LoggerFactory.getLogger(URLPluginSetupDescriptor.class).debug("Creating classpath for {}", (Object)Arrays.toString(this.urls));
        return this.createClassLoader(this.urls, parent);
    }

    protected ClassLoader createClassLoader(URL[] urls, ClassLoader parent) {
        return new ChildFirstURLClassLoader(urls, parent);
    }

    protected URL[] getURLs() {
        return this.urls;
    }
}

