/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.setup;

import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.MultiResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.setup.EnableSetupMerge;
import de.iip_ecosphere.platform.support.yaml.Yaml;
import de.iip_ecosphere.platform.support.yaml.YamlFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractSetup {
    public static final String PARAM_PLUGINS = "iip.plugins";
    public static final String DEFAULT_NAME = "iipecosphere";
    public static final String DEFAULT_FNAME = "iipecosphere.yml";
    public static final String DEFAULT_OVERRIDE_FNAME = "oktoflow-local.yml";
    private static String defaultFName = "iipecosphere.yml";
    private String pluginsFolder = OsUtils.getPropertyOrEnv("iip.plugins", "plugins");

    public static String getDefaultFileName() {
        return defaultFName;
    }

    public static String setDefaultFileName(String name) {
        String oldFName = defaultFName;
        defaultFName = name;
        return oldFName;
    }

    public void setPluginsFolder(String pluginsFolder) {
        this.pluginsFolder = pluginsFolder;
    }

    public void setPluginsFolderFile(File pluginsFolder) {
        this.setPluginsFolder(null == pluginsFolder ? null : pluginsFolder.toString());
    }

    public String getPluginsFolder() {
        return this.pluginsFolder;
    }

    public static <C> C readFromYaml(Class<C> cls) throws IOException {
        return AbstractSetup.readFromYamlWithPath(cls, null);
    }

    public static <C> C readFromYamlWithPath(Class<C> cls, String yamlPath) throws IOException {
        return AbstractSetup.readFromYamlWithPath(cls, yamlPath, AbstractSetup.getDefaultFileName(), DEFAULT_OVERRIDE_FNAME);
    }

    public static <C> C readFromYaml(Class<C> cls, String filename) throws IOException {
        return AbstractSetup.readFromYamlWithPath(cls, null, filename, null);
    }

    public static <C> C readFromYamlWithPath(Class<C> cls, String yamlPath, String filename) throws IOException {
        return AbstractSetup.readFromYamlWithPath(cls, yamlPath, filename, null);
    }

    public static <C> C readFromYaml(Class<C> cls, String filename, String overwrite) throws IOException {
        return AbstractSetup.readFromYamlWithPath(cls, null, filename, overwrite);
    }

    public static <C> C readFromYamlWithPath(Class<C> cls, String yamlPath, String filename, String overwrite) throws IOException {
        InputStream in = ResourceLoader.getResourceAsStream(filename, new ResourceResolver[0]);
        if (null == in) {
            throw new IOException("Cannot read " + filename);
        }
        InputStream over = null;
        if (null != overwrite) {
            over = ResourceLoader.getResourceAsStream(overwrite, MultiResourceResolver.SETUP_RESOLVER);
        }
        return AbstractSetup.readFromYamlWithPath(cls, yamlPath, in, over);
    }

    public static Map<String, Object> readMappingFromYaml() throws IOException {
        return AbstractSetup.readMappingFromYaml(AbstractSetup.getDefaultFileName());
    }

    public static Map<String, Object> readMappingFromYaml(String filename) throws IOException {
        InputStream in = ResourceLoader.getResourceAsStream(filename, new ResourceResolver[0]);
        if (null == in) {
            throw new IOException("Cannot read " + filename);
        }
        return Yaml.getInstance().loadMapping(in);
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static <C> C readFromYaml(Class<C> cls, InputStream in) throws IOException {
        return AbstractSetup.readFromYaml(cls, in, null);
    }

    public static <C> C readFromYaml(Class<C> cls, InputStream in, InputStream overwrite) throws IOException {
        return AbstractSetup.readFromYamlWithPath(cls, null, in, overwrite);
    }

    public static <C> C readFromYamlWithPath(Class<C> cls, String yamlPath, InputStream in, InputStream overwrite) throws IOException {
        Object result = null;
        if (in != null) {
            try {
                Object o;
                Iterator<Object> it = Yaml.getInstance().loadAll(in, yamlPath, cls);
                if (it.hasNext() && cls.isInstance(o = it.next())) {
                    result = cls.cast(o);
                }
                in.close();
            }
            catch (IOException e) {
                in.close();
                throw new IOException(e);
            }
        }
        if (null == result) {
            LoggerFactory.getLogger(AbstractSetup.class).info("No input YAML file, falling back to default instance for " + cls.getName());
            try {
                result = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        if (null != overwrite) {
            boolean hasAnnotation = false;
            for (Class<C> iter = cls; iter != null && iter != Object.class && !hasAnnotation; iter = iter.getSuperclass()) {
                hasAnnotation = iter.getAnnotation(EnableSetupMerge.class) != null;
            }
            if (hasAnnotation) {
                try {
                    Map<String, Object> data = Yaml.getInstance().loadMapping(overwrite);
                    result = YamlFile.overwrite(result, cls, data);
                    overwrite.close();
                }
                catch (IOException e) {
                    overwrite.close();
                    LoggerFactory.getLogger(AbstractSetup.class).error("Cannot overwrite setup: {} Ignoring.", (Object)e.getMessage());
                }
            }
        }
        return result;
    }
}

