/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.websocket;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.websocket.WebsocketFactoryProviderDescriptor;
import java.io.IOException;
import java.net.URI;
import java.util.function.Consumer;

public abstract class WebsocketFactory {
    private static WebsocketFactory instance = PluginManager.getPluginInstance(WebsocketFactory.class, WebsocketFactoryProviderDescriptor.class);

    public static WebsocketFactory getInstance() {
        return instance;
    }

    public static void setInstance(WebsocketFactory rest) {
        if (null != rest) {
            instance = rest;
        }
    }

    public abstract WebSocket createSocket(URI var1) throws IOException;

    public abstract Server createBroadcastingServer(ServerAddress var1) throws IOException;

    public static interface WebSocket {
        public void setReceptionHander(Consumer<String> var1);

        public void setStatusListener(StatusListener var1);

        public void connect() throws IOException;

        public boolean connectBlocking() throws IOException;

        public void send(String var1) throws IOException;

        public void close() throws IOException;

        public void closeBocking() throws IOException;

        public URI getURI();

        public boolean isOpen();

        public boolean isClosed();
    }

    public static interface StatusListener {
        public void onConnect();

        public void onClose(String var1, boolean var2);

        public void onError(String var1);
    }
}

