/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.security.Principal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Property;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleInspector;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.config.RuleSetBuilder;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RuleSetImpl
extends AbstractList<Rule>
implements RuleSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleSet.class);
    private static final String CHECKING_AGAINST_RULE = "Checking against rule: {}";
    private static final String CHECKING_ACTION_OPERATION_OBJECT_PROPERTIES = "Checking action: operation={}, object={}, properties={}";
    private final List<Rule> _rules;
    private final Map<LegacyOperation, Map<ObjectType, RuleInspector>> _cache;
    private final EventLoggerProvider _eventLogger;
    private final DefaultResultInspector _defaultInspector;

    RuleSetImpl(RuleSetBuilder builder) {
        this._rules = new ArrayList<Rule>(builder);
        this._eventLogger = builder.getEventLogger();
        this._defaultInspector = builder.getDefaultInspector();
        this._cache = builder.buildCache();
    }

    @Override
    public Result getDefault() {
        return this._defaultInspector.getDefaultResult();
    }

    @Override
    public Result check(Subject subject, LegacyOperation operation, ObjectType objectType, ObjectProperties properties) {
        return this._cache.get((Object)operation).get((Object)objectType).check(subject, operation, objectType, properties);
    }

    public EventLogger getEventLogger() {
        return this._eventLogger.getEventLogger();
    }

    @Override
    public Rule get(int index) {
        return this._rules.get(index);
    }

    @Override
    public int size() {
        return this._rules.size();
    }

    static final class RuleBasedInspectorWithOwnerFilteringFactory
    extends AbstractInspectorFactory {
        public static RuleInspector.RuleInspectorFactory newInstance(List<? extends Rule> rules, EventLoggerProvider logger) {
            return new RuleBasedInspectorWithOwnerFilteringFactory(rules, logger);
        }

        RuleBasedInspectorWithOwnerFilteringFactory(List<? extends Rule> rules, EventLoggerProvider logger) {
            super(rules, logger);
        }

        @Override
        boolean matchAnyIdentity(Rule rule) {
            return rule.isForOwnerOrAll();
        }

        @Override
        RuleInspector newInspector(List<? extends Rule> filteredRules, EventLoggerProvider logger) {
            return new RuleBasedInspectorWithOwnerFiltering(filteredRules, logger);
        }
    }

    static final class RuleBasedInspectorFactory
    extends AbstractInspectorFactory {
        public static RuleInspector.RuleInspectorFactory newInstance(List<? extends Rule> rules, EventLoggerProvider logger) {
            return new RuleBasedInspectorFactory(rules, logger);
        }

        RuleBasedInspectorFactory(List<? extends Rule> rules, EventLoggerProvider logger) {
            super(rules, logger);
        }

        @Override
        boolean matchAnyIdentity(Rule rule) {
            return rule.isForAll();
        }

        @Override
        RuleInspector newInspector(List<? extends Rule> filteredRules, EventLoggerProvider logger) {
            return new RuleBasedInspector(filteredRules, logger);
        }
    }

    private static abstract class AbstractInspectorFactory
    implements RuleInspector.RuleInspectorFactory {
        private final EventLoggerProvider _logger;
        private final Rule[] _rules;
        private final Set<String> _allRuleIdentities;

        abstract boolean matchAnyIdentity(Rule var1);

        abstract RuleInspector newInspector(List<? extends Rule> var1, EventLoggerProvider var2);

        AbstractInspectorFactory(List<? extends Rule> rules, EventLoggerProvider logger) {
            List<? extends Rule> filterRules = this.filterSuppressedRules(rules);
            this._rules = filterRules.toArray(new Rule[0]);
            this._logger = Objects.requireNonNull(logger);
            this._allRuleIdentities = this.collectRuleIdentities(filterRules);
        }

        @Override
        public Set<String> allRuleIdentities() {
            return Collections.unmodifiableSet(this._allRuleIdentities);
        }

        @Override
        public RuleInspector newInspector(Set<String> principalNames) {
            ArrayList<Rule> filteredRules = new ArrayList<Rule>();
            for (Rule rule : this._rules) {
                if (!this.matchAnyIdentity(rule) && !principalNames.contains(rule.getIdentity())) continue;
                filteredRules.add(rule);
            }
            return this.newInspector(filteredRules, this._logger);
        }

        private Set<String> collectRuleIdentities(Collection<? extends Rule> rules) {
            return rules.stream().filter(rule -> !rule.isForOwnerOrAll()).map(Rule::getIdentity).collect(Collectors.toSet());
        }

        private List<? extends Rule> filterSuppressedRules(List<? extends Rule> rules) {
            ListIterator<? extends Rule> iter = rules.listIterator();
            while (iter.hasNext()) {
                Rule rule = iter.next();
                if (!this.isFinalRule(rule)) continue;
                return rules.subList(0, iter.nextIndex());
            }
            return rules;
        }

        private boolean isFinalRule(Rule rule) {
            return rule.anyPropertiesMatch() && rule.isForAll();
        }
    }

    private static final class RuleBasedInspectorWithOwnerFiltering
    implements RuleInspector {
        private final Rule[] _rules;
        private final EventLoggerProvider _logger;

        RuleBasedInspectorWithOwnerFiltering(Collection<? extends Rule> rules, EventLoggerProvider logger) {
            this._logger = logger;
            this._rules = rules.toArray(new Rule[0]);
        }

        @Override
        public Result check(Subject subject, LegacyOperation operation, ObjectType objectType, ObjectProperties properties) {
            LOGGER.debug(RuleSetImpl.CHECKING_ACTION_OPERATION_OBJECT_PROPERTIES, new Object[]{operation, objectType, properties});
            Object objectCreator = properties.get(Property.CREATED_BY);
            AuthenticatedPrincipal principal = AuthenticatedPrincipal.getOptionalAuthenticatedPrincipalFromSubject((Subject)subject);
            if (principal != null && principal.getName().equals(objectCreator)) {
                for (Rule rule : this._rules) {
                    LOGGER.debug(RuleSetImpl.CHECKING_AGAINST_RULE, (Object)rule);
                    if (!rule.predicatesMatch(operation, properties, subject)) continue;
                    return rule.getOutcome().logResult(this._logger, operation, objectType, properties);
                }
            } else {
                for (Rule rule : this._rules) {
                    LOGGER.debug(RuleSetImpl.CHECKING_AGAINST_RULE, (Object)rule);
                    if (rule.isForOwner() || !rule.predicatesMatch(operation, properties, subject)) continue;
                    return rule.getOutcome().logResult(this._logger, operation, objectType, properties);
                }
            }
            LOGGER.debug("Deferring result of ACL check");
            return Result.DEFER;
        }
    }

    private static final class RuleBasedInspector
    implements RuleInspector {
        private final EventLoggerProvider _logger;
        private final Rule[] _rules;

        RuleBasedInspector(Collection<? extends Rule> rules, EventLoggerProvider logger) {
            this._logger = logger;
            this._rules = rules.toArray(new Rule[0]);
        }

        @Override
        public Result check(Subject subject, LegacyOperation operation, ObjectType objectType, ObjectProperties properties) {
            LOGGER.debug(RuleSetImpl.CHECKING_ACTION_OPERATION_OBJECT_PROPERTIES, new Object[]{operation, objectType, properties});
            for (Rule rule : this._rules) {
                LOGGER.debug(RuleSetImpl.CHECKING_AGAINST_RULE, (Object)rule);
                if (!rule.predicatesMatch(operation, properties, subject)) continue;
                return rule.getOutcome().logResult(this._logger, operation, objectType, properties);
            }
            LOGGER.debug("Deferring result of ACL check");
            return Result.DEFER;
        }
    }

    static final class DefaultResultInspector
    implements RuleInspector {
        private final Result _defaultResult;

        DefaultResultInspector(Result defaultResult) {
            this._defaultResult = Optional.ofNullable(defaultResult).orElse(Result.DENIED);
        }

        @Override
        public Result check(Subject subject, LegacyOperation operation, ObjectType objectType, ObjectProperties properties) {
            LOGGER.debug("No rules found, returning default result");
            return this._defaultResult;
        }

        public Result getDefaultResult() {
            return this._defaultResult;
        }
    }

    static final class CachedInspector
    implements RuleInspector {
        private final Map<Set<String>, RuleInspector> _cache = new ConcurrentHashMap<Set<String>, RuleInspector>();
        private final Set<String> _ruleIdentities;
        private final RuleInspector.RuleInspectorFactory _factory;

        CachedInspector(RuleInspector.RuleInspectorFactory factory) {
            this._ruleIdentities = new HashSet<String>(factory.allRuleIdentities());
            this._factory = factory;
        }

        public CachedInspector init() {
            Set<String> empty = Collections.emptySet();
            this._cache.put(empty, this._factory.newInspector(empty));
            for (String ruleIdentity : this._ruleIdentities) {
                Set<String> identities = Collections.singleton(ruleIdentity);
                this._cache.put(identities, this._factory.newInspector(identities));
            }
            return this;
        }

        @Override
        public Result check(Subject subject, LegacyOperation operation, ObjectType objectType, ObjectProperties properties) {
            Set<String> relevantPrincipals = this.collectPrincipalNames(subject);
            relevantPrincipals.retainAll(this._ruleIdentities);
            return this._cache.computeIfAbsent(relevantPrincipals, this._factory::newInspector).check(subject, operation, objectType, properties);
        }

        private Set<String> collectPrincipalNames(Subject subject) {
            Set<Principal> principals = subject.getPrincipals();
            HashSet<String> principalNames = new HashSet<String>(principals.size());
            for (Principal principal : principals) {
                principalNames.add(principal.getName());
            }
            return principalNames;
        }
    }
}

