/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceRequirements describes the compute resource requirements.")
public class V1ResourceRequirements {
    public static final String SERIALIZED_NAME_LIMITS = "limits";
    @SerializedName(value="limits")
    private Map<String, Quantity> limits = null;
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    private Map<String, Quantity> requests = null;

    public V1ResourceRequirements limits(Map<String, Quantity> limits) {
        this.limits = limits;
        return this;
    }

    public V1ResourceRequirements putLimitsItem(String key, Quantity limitsItem) {
        if (this.limits == null) {
            this.limits = new HashMap<String, Quantity>();
        }
        this.limits.put(key, limitsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/")
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, Quantity> limits) {
        this.limits = limits;
    }

    public V1ResourceRequirements requests(Map<String, Quantity> requests) {
        this.requests = requests;
        return this;
    }

    public V1ResourceRequirements putRequestsItem(String key, Quantity requestsItem) {
        if (this.requests == null) {
            this.requests = new HashMap<String, Quantity>();
        }
        this.requests.put(key, requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/")
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    public void setRequests(Map<String, Quantity> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceRequirements v1ResourceRequirements = (V1ResourceRequirements)o;
        return Objects.equals(this.limits, v1ResourceRequirements.limits) && Objects.equals(this.requests, v1ResourceRequirements.requests);
    }

    public int hashCode() {
        return Objects.hash(this.limits, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceRequirements {\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

