/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.contactInformations;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.MultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodel;
import de.iip_ecosphere.platform.support.aas.types.common.DelegatingSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.types.common.Utils;
import de.iip_ecosphere.platform.support.aas.types.contactInformations.ContactInformationsBuilder;
import java.util.concurrent.ExecutionException;

public class ContactInformations
extends DelegatingSubmodel {
    public ContactInformations(Aas aas) {
        super(aas.getSubmodel("ContactInformations"));
    }

    public ContactInformation getContactInformation(int index) {
        SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("ContactInformation", index));
        return null == tmp ? null : new ContactInformation(tmp);
    }

    public static class ContactInformation
    extends DelegatingSubmodelElementCollection {
        protected ContactInformation(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getRoleOfContactPersonProperty() {
            return this.getProperty("RoleOfContactPerson");
        }

        public ContactInformationsBuilder.IRoleOfContactPerson getRoleOfContactPerson() throws ExecutionException {
            return Utils.getEnumValue(this, "RoleOfContactPerson", ContactInformationsBuilder.IRoleOfContactPerson.class, ContactInformationsBuilder.RoleOfContactPerson.class);
        }

        public MultiLanguageProperty getNationalCodeProperty() {
            return (MultiLanguageProperty)this.getDataElement("NationalCode");
        }

        public LangString[] getNationalCode() throws ExecutionException {
            return Utils.getLangStringValue(this, "NationalCode");
        }

        public Property getLanguageProperty(int index) {
            return this.getProperty(Utils.getCountingIdShort("Language", index));
        }

        public Iterable<String> getLanguage() throws ExecutionException {
            return Utils.collect(this.elements(), Property.class, IdentifierType.iri("https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/Language"), p -> Utils.cast(p, String.class));
        }

        public Property getTimeZoneProperty() {
            return this.getProperty("TimeZone");
        }

        public String getTimeZone() throws ExecutionException {
            return Utils.getStringValue(this, "TimeZone");
        }

        public MultiLanguageProperty getCityTownProperty() {
            return (MultiLanguageProperty)this.getDataElement("CityTown");
        }

        public LangString[] getCityTown() throws ExecutionException {
            return Utils.getLangStringValue(this, "CityTown");
        }

        public MultiLanguageProperty getCompanyProperty() {
            return (MultiLanguageProperty)this.getDataElement("Company");
        }

        public LangString[] getCompany() throws ExecutionException {
            return Utils.getLangStringValue(this, "Company");
        }

        public MultiLanguageProperty getDepartmentProperty() {
            return (MultiLanguageProperty)this.getDataElement("Department");
        }

        public LangString[] getDepartment() throws ExecutionException {
            return Utils.getLangStringValue(this, "Department");
        }

        public Phone getPhone() {
            return new Phone(super.getSubmodelElementCollection("Phone"));
        }

        public Fax getFax() {
            return new Fax(super.getSubmodelElementCollection("Fax"));
        }

        public Email getEmail() {
            return new Email(super.getSubmodelElementCollection("Email"));
        }

        public IPCommunication getIPCommunication(int index) {
            SubmodelElementCollection tmp = super.getSubmodelElementCollection(Utils.getCountingIdShort("IPCommunication", index));
            return null == tmp ? null : new IPCommunication(tmp);
        }

        public MultiLanguageProperty getStreetProperty() {
            return (MultiLanguageProperty)this.getDataElement("Street");
        }

        public LangString[] getStreet() throws ExecutionException {
            return Utils.getLangStringValue(this, "Street");
        }

        public MultiLanguageProperty getZipcodeProperty() {
            return (MultiLanguageProperty)this.getDataElement("Zipcode");
        }

        public LangString[] getZipcode() throws ExecutionException {
            return Utils.getLangStringValue(this, "Zipcode");
        }

        public MultiLanguageProperty getPOBoxProperty() {
            return (MultiLanguageProperty)this.getDataElement("POBox");
        }

        public LangString[] getPOBox() throws ExecutionException {
            return Utils.getLangStringValue(this, "POBox");
        }

        public MultiLanguageProperty getZipCodeOfPOBoxProperty() {
            return (MultiLanguageProperty)this.getDataElement("ZipCodeOfPOBox");
        }

        public LangString[] getZipCodeOfPOBox() throws ExecutionException {
            return Utils.getLangStringValue(this, "ZipCodeOfPOBox");
        }

        public MultiLanguageProperty getStateCountyProperty() {
            return (MultiLanguageProperty)this.getDataElement("StateCounty");
        }

        public LangString[] getStateCounty() throws ExecutionException {
            return Utils.getLangStringValue(this, "StateCounty");
        }

        public MultiLanguageProperty getNameOfContactProperty() {
            return (MultiLanguageProperty)this.getDataElement("NameOfContact");
        }

        public LangString[] getNameOfContact() throws ExecutionException {
            return Utils.getLangStringValue(this, "NameOfContact");
        }

        public MultiLanguageProperty getFirstNameProperty() {
            return (MultiLanguageProperty)this.getDataElement("FirstName");
        }

        public LangString[] getFirstName() throws ExecutionException {
            return Utils.getLangStringValue(this, "FirstName");
        }

        public MultiLanguageProperty getMiddleNamesProperty() {
            return (MultiLanguageProperty)this.getDataElement("MiddleNames");
        }

        public LangString[] getMiddleNames() throws ExecutionException {
            return Utils.getLangStringValue(this, "MiddleNames");
        }

        public MultiLanguageProperty getTitleProperty() {
            return (MultiLanguageProperty)this.getDataElement("Title");
        }

        public LangString[] getTitle() throws ExecutionException {
            return Utils.getLangStringValue(this, "Title");
        }

        public MultiLanguageProperty getAcademicTitleProperty() {
            return (MultiLanguageProperty)this.getDataElement("AcademicTitle");
        }

        public LangString[] getAcademicTitle() throws ExecutionException {
            return Utils.getLangStringValue(this, "AcademicTitle");
        }

        public MultiLanguageProperty getFurtherDetailsOfContactProperty() {
            return (MultiLanguageProperty)this.getDataElement("FurtherDetailsOfContact");
        }

        public LangString[] getFurtherDetailsOfContact() throws ExecutionException {
            return Utils.getLangStringValue(this, "FurtherDetailsOfContact");
        }

        public Property getAddressOfAdditionalLinkProperty() {
            return this.getProperty("AddressOfAdditionalLink");
        }

        public String getAddressOfAdditionalLink() throws ExecutionException {
            return Utils.getStringValue(this, "AddressOfAdditionalLink");
        }
    }

    public static class IPCommunication
    extends DelegatingSubmodelElementCollection {
        protected IPCommunication(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getAddressOfAdditionalLinkProperty() {
            return this.getProperty("AddressOfAdditionalLink");
        }

        public String getAddressOfAdditionalLink() throws ExecutionException {
            return Utils.getStringValue(this, "AddressOfAdditionalLink");
        }

        public Property getTypeOfCommunicationProperty() {
            return this.getProperty("TypeOfCommunication");
        }

        public String getTypeOfCommunication() throws ExecutionException {
            return Utils.getStringValue(this, "TypeOfCommunication");
        }

        public MultiLanguageProperty getAvailableTimeProperty() {
            return (MultiLanguageProperty)this.getDataElement("AvailableTime");
        }

        public LangString[] getAvailableTime() throws ExecutionException {
            return Utils.getLangStringValue(this, "AvailableTime");
        }
    }

    public static class Email
    extends DelegatingSubmodelElementCollection {
        protected Email(SubmodelElementCollection parent) {
            super(parent);
        }

        public Property getEmailAddressProperty() {
            return this.getProperty("EmailAddress");
        }

        public String getEmailAddress() throws ExecutionException {
            return Utils.getStringValue(this, "EmailAddress");
        }

        public MultiLanguageProperty getPublicKeyProperty() {
            return (MultiLanguageProperty)this.getDataElement("PublicKey");
        }

        public LangString[] getPublicKey() throws ExecutionException {
            return Utils.getLangStringValue(this, "PublicKey");
        }

        public Property getTypeOfEmailAddressProperty() {
            return this.getProperty("TypeOfEmailAddress");
        }

        public ContactInformationsBuilder.TypeOfEmailAddress getTypeOfEmailAddress() throws ExecutionException {
            return Utils.getEnumValue(this, "TypeOfEmailAddress", ContactInformationsBuilder.TypeOfEmailAddress.class, ContactInformationsBuilder.TypeOfEmailAddress.class);
        }

        public MultiLanguageProperty getTypeOfPublicKeyProperty() {
            return (MultiLanguageProperty)this.getDataElement("TypeOfPublicKey");
        }

        public LangString[] getTypeOfPublicKey() throws ExecutionException {
            return Utils.getLangStringValue(this, "TypeOfPublicKey");
        }
    }

    public static class Fax
    extends DelegatingSubmodelElementCollection {
        protected Fax(SubmodelElementCollection parent) {
            super(parent);
        }

        public MultiLanguageProperty getFaxNumberProperty() {
            return (MultiLanguageProperty)this.getDataElement("FaxNumber");
        }

        public LangString[] getFaxNumber() throws ExecutionException {
            return Utils.getLangStringValue(this, "FaxNumber");
        }

        public Property getTypeOfFaxNumberProperty() {
            return this.getProperty("TypeOfFaxNumber");
        }

        public ContactInformationsBuilder.TypeOfFaxNumber getTypeOfFaxNumber() throws ExecutionException {
            return Utils.getEnumValue(this, "TypeOfFaxNumber", ContactInformationsBuilder.TypeOfFaxNumber.class, ContactInformationsBuilder.TypeOfFaxNumber.class);
        }
    }

    public static class Phone
    extends DelegatingSubmodelElementCollection {
        protected Phone(SubmodelElementCollection parent) {
            super(parent);
        }

        public MultiLanguageProperty getTelephoneNumberProperty() {
            return (MultiLanguageProperty)this.getDataElement("TelephoneNumber");
        }

        public LangString[] getTelephoneNumber() throws ExecutionException {
            return Utils.getLangStringValue(this, "TelephoneNumber");
        }

        public Property getTypeOfTelephoneProperty() {
            return this.getProperty("TypeOfTelephone");
        }

        public ContactInformationsBuilder.TypeOfTelephone getTypeOfTelephone() throws ExecutionException {
            return Utils.getEnumValue(this, "TypeOfTelephone", ContactInformationsBuilder.TypeOfTelephone.class, ContactInformationsBuilder.TypeOfTelephone.class);
        }

        public MultiLanguageProperty getAvailableTimeProperty() {
            return (MultiLanguageProperty)this.getDataElement("AvailableTime");
        }

        public LangString[] getAvailableTime() throws ExecutionException {
            return Utils.getLangStringValue(this, "AvailableTime");
        }
    }
}

