/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap;

import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.connection.ConnectionPersistence;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyShutdownHook
implements HiveMQShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(NettyShutdownHook.class);
    @NotNull
    private final EventLoopGroup workerGroup;
    @NotNull
    private final EventLoopGroup bossGroup;
    private final int eventLoopsShutdownTimeout;
    private final int connectionPersistenceShutdownTimeout;
    @NotNull
    private final ConnectionPersistence connectionPersistence;

    public NettyShutdownHook(@NotNull EventLoopGroup workerGroup, @NotNull EventLoopGroup bossGroup, int eventLoopsShutdownTimeout, int connectionPersistenceShutdownTimeout, @NotNull ConnectionPersistence connectionPersistence) {
        this.workerGroup = workerGroup;
        this.bossGroup = bossGroup;
        this.eventLoopsShutdownTimeout = eventLoopsShutdownTimeout;
        this.connectionPersistenceShutdownTimeout = connectionPersistenceShutdownTimeout;
        this.connectionPersistence = connectionPersistence;
    }

    @Override
    @NotNull
    public String name() {
        return "Netty Shutdown";
    }

    @Override
    @NotNull
    public HiveMQShutdownHook.Priority priority() {
        return HiveMQShutdownHook.Priority.MEDIUM;
    }

    @Override
    public void run() {
        log.debug("Shutting down listeners and clients");
        try {
            this.connectionPersistence.shutDown().get((long)this.connectionPersistenceShutdownTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Client shutdown failed exceptionally: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("Original Exception: ", (Throwable)e);
            }
        }
        catch (TimeoutException e) {
            log.warn("Client shutdown timed out.");
            if (log.isDebugEnabled()) {
                log.debug("Original Exception: ", (Throwable)e);
            }
        }
        finally {
            this.connectionPersistence.interruptShutdown();
        }
        log.debug("Shutting down worker and boss threads");
        Future workerFinished = this.workerGroup.shutdownGracefully(2L, (long)this.eventLoopsShutdownTimeout, TimeUnit.SECONDS);
        Future bossFinished = this.bossGroup.shutdownGracefully(2L, (long)this.eventLoopsShutdownTimeout, TimeUnit.SECONDS);
        log.trace("Waiting for Worker threads to finish");
        workerFinished.syncUninterruptibly();
        log.trace("Waiting for Boss threads to finish");
        bossFinished.syncUninterruptibly();
    }
}

