/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty.initializer;

import com.hivemq.bootstrap.netty.ChannelDependencies;
import com.hivemq.bootstrap.netty.initializer.AbstractChannelInitializer;
import com.hivemq.configuration.service.entity.WebsocketListener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.security.ssl.NonSslHandler;
import com.hivemq.websocket.WebSocketInitializer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import javax.inject.Provider;

public class WebsocketChannelInitializer
extends AbstractChannelInitializer {
    @NotNull
    private final WebsocketListener websocketListener;
    @NotNull
    private final Provider<NonSslHandler> nonSslHandlerProvider;

    public WebsocketChannelInitializer(@NotNull ChannelDependencies channelDependencies, @NotNull WebsocketListener websocketListener, @NotNull Provider<NonSslHandler> nonSslHandlerProvider) {
        super(channelDependencies, websocketListener);
        this.websocketListener = websocketListener;
        this.nonSslHandlerProvider = nonSslHandlerProvider;
    }

    @Override
    protected void addSpecialHandlers(@NotNull Channel ch) {
        ch.pipeline().addFirst("no_ssl_handler", (ChannelHandler)this.nonSslHandlerProvider.get());
        new WebSocketInitializer(this.websocketListener).addHandlers(ch, "no_ssl_handler");
    }
}

