/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.codec.encoder.mqtt5.MqttBinaryData;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.auth.AUTH;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;

@LazySingleton
public class Mqtt5AuthDecoder
extends AbstractMqttDecoder<AUTH> {
    @Inject
    public Mqtt5AuthDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public AUTH decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        Preconditions.checkNotNull((Object)clientConnectionContext, (Object)"ClientContext must not be null");
        Preconditions.checkNotNull((Object)buf, (Object)"ByteBuf must not be null");
        if (!this.validateHeader(header)) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.AUTH);
            return null;
        }
        if (buf.readableBytes() < 1) {
            return AUTH.getSuccessAUTH();
        }
        Mqtt5AuthReasonCode code = Mqtt5AuthReasonCode.fromCode(buf.readUnsignedByte());
        if (code == null) {
            this.disconnectByInvalidReasonCode(clientConnectionContext, MessageType.AUTH);
            return null;
        }
        if (code.equals(Mqtt5AuthReasonCode.SUCCESS) && buf.readableBytes() == 0) {
            return AUTH.getSuccessAUTH();
        }
        int propertiesLength = this.decodePropertiesLengthNoPayload(clientConnectionContext, buf, MessageType.AUTH);
        if (propertiesLength == -1) {
            return null;
        }
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        String reasonString = null;
        String authenticationMethod = null;
        byte[] authenticationData = null;
        block6: while (buf.isReadable()) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 21: {
                    if ((authenticationMethod = this.decodeAuthenticationMethod(clientConnectionContext, buf, authenticationMethod, MessageType.AUTH)) != null) continue block6;
                    return null;
                }
                case 22: {
                    if ((authenticationData = this.readAuthenticationData(clientConnectionContext, buf, authenticationData)) != null) continue block6;
                    return null;
                }
                case 31: {
                    if ((reasonString = this.decodeReasonString(clientConnectionContext, buf, reasonString, MessageType.AUTH)) != null) continue block6;
                    return null;
                }
                case 38: {
                    if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder, MessageType.AUTH)) != null) continue block6;
                    return null;
                }
            }
            this.disconnectByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier, MessageType.AUTH);
            return null;
        }
        if (authenticationMethod == null) {
            this.disconnectByInvalidAuthMethod(clientConnectionContext, MessageType.AUTH);
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, MessageType.AUTH, userProperties)) {
            return null;
        }
        return new AUTH(authenticationMethod, authenticationData, code, userProperties, reasonString);
    }

    private byte @Nullable [] readAuthenticationData(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte @Nullable [] authenticationData) {
        if (authenticationData != null) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "auth data", MessageType.AUTH);
            return null;
        }
        authenticationData = MqttBinaryData.decode(buf);
        if (authenticationData == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent an AUTH with a malformed authentication data. This is not allowed. Disconnecting client.", "sent an AUTH with a malformed authentication data", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, "AUTH with malformed authentication data was sent.");
            return null;
        }
        return authenticationData;
    }
}

