/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.EncoderFactory;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.metrics.handler.GlobalMQTTMessageCounter;
import com.hivemq.mqtt.message.Message;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

@ChannelHandler.Sharable
public class MQTTMessageEncoder
extends MessageToByteEncoder<Message> {
    @NotNull
    private final EncoderFactory encoderFactory;
    @NotNull
    private final GlobalMQTTMessageCounter globalMQTTMessageCounter;

    @Inject
    public MQTTMessageEncoder(@NotNull EncoderFactory encoderFactory, @NotNull GlobalMQTTMessageCounter globalMQTTMessageCounter) {
        this.encoderFactory = encoderFactory;
        this.globalMQTTMessageCounter = globalMQTTMessageCounter;
    }

    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull Message msg, @NotNull ByteBuf out) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        this.globalMQTTMessageCounter.countOutbound(msg);
        this.encoderFactory.encode(clientConnectionContext, msg, out);
        this.globalMQTTMessageCounter.countOutboundTraffic(out.readableBytes());
    }

    @NotNull
    protected ByteBuf allocateBuffer(@NotNull ChannelHandlerContext ctx, @NotNull Message msg, boolean preferDirect) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        return this.encoderFactory.allocateBuffer(clientConnectionContext, msg, preferDirect);
    }
}

