/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt3;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.MqttEncoder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.connack.Mqtt3CONNACK;
import com.hivemq.mqtt.message.connack.Mqtt3ConnAckReturnCode;
import io.netty.buffer.ByteBuf;

public class Mqtt3ConnackEncoder
implements MqttEncoder<Mqtt3CONNACK> {
    private static final byte CONNACK_FIXED_HEADER = 32;
    private static final byte CONNACK_REMAINING_LENGTH = 2;
    private static final byte CONNACK_FLAGS_EMPTY = 0;
    private static final byte CONNACK_FLAGS_SP_SET = 1;
    private static final int ENCODED_CONNACK_SIZE = 4;

    @Override
    public void encode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull Mqtt3CONNACK msg, @NotNull ByteBuf out) {
        out.writeByte(32);
        out.writeByte(2);
        Mqtt3ConnAckReturnCode returnCode = msg.getReturnCode();
        switch (clientConnectionContext.getProtocolVersion()) {
            case MQTTv3_1: {
                out.writeByte(0);
                break;
            }
            case MQTTv3_1_1: {
                if (returnCode == Mqtt3ConnAckReturnCode.ACCEPTED && msg.isSessionPresent()) {
                    out.writeByte(1);
                    break;
                }
                out.writeByte(0);
            }
        }
        out.writeByte(returnCode.getCode());
    }

    @Override
    public int bufferSize(@NotNull ClientConnectionContext clientConnectionContext, @NotNull Mqtt3CONNACK connack) {
        return 4;
    }
}

