/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.auth.AUTH;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;
import io.netty.buffer.ByteBuf;

public class Mqtt5AuthEncoder
extends Mqtt5MessageWithUserPropertiesEncoder.Mqtt5MessageWithOmissibleReasonCodeEncoder<AUTH, Mqtt5AuthReasonCode> {
    private static final int FIXED_HEADER = MessageType.AUTH.ordinal() << 4;

    public Mqtt5AuthEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
        super(messageDroppedService, securityConfigurationService);
    }

    @Override
    int getFixedHeader() {
        return FIXED_HEADER;
    }

    @Override
    @NotNull
    Mqtt5AuthReasonCode getDefaultReasonCode() {
        return Mqtt5AuthReasonCode.SUCCESS;
    }

    @Override
    int additionalPropertyLength(@NotNull AUTH auth) {
        if (auth.getAuthMethod().isEmpty()) {
            return 0;
        }
        int propertyLength = 0;
        propertyLength += Mqtt5MessageEncoderUtil.propertyEncodedLength(auth.getAuthMethod());
        return propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(auth.getAuthData());
    }

    @Override
    void encodeAdditionalProperties(@NotNull AUTH auth, @NotNull ByteBuf out) {
        if (auth.getAuthMethod().isEmpty()) {
            return;
        }
        Mqtt5MessageEncoderUtil.encodeProperty(21, auth.getAuthMethod(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(22, auth.getAuthData(), out);
    }
}

