/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.common.shutdown;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.Comparator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

@Singleton
public class ShutdownHooks {
    private static final Logger log = LoggerFactory.getLogger(ShutdownHooks.class);
    @NotNull
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    @NotNull
    private final Multimap<Integer, HiveMQShutdownHook> synchronousHooks = MultimapBuilder.SortedSetMultimapBuilder.treeKeys((Comparator)Ordering.natural().reverse()).arrayListValues().build();

    @Inject
    public ShutdownHooks() {
    }

    public boolean isShuttingDown() {
        return this.shuttingDown.get();
    }

    public synchronized void add(@NotNull HiveMQShutdownHook hiveMQShutdownHook) {
        if (this.shuttingDown.get()) {
            return;
        }
        Preconditions.checkNotNull((Object)hiveMQShutdownHook, (Object)"A shutdown hook must not be null");
        log.trace("Adding shutdown hook {} with priority {}", (Object)hiveMQShutdownHook.name(), (Object)hiveMQShutdownHook.priority());
        this.synchronousHooks.put((Object)hiveMQShutdownHook.priority().getValue(), (Object)hiveMQShutdownHook);
    }

    public synchronized void remove(@NotNull HiveMQShutdownHook hiveMQShutdownHook) {
        if (this.shuttingDown.get()) {
            return;
        }
        Preconditions.checkNotNull((Object)hiveMQShutdownHook, (Object)"A shutdown hook must not be null");
        log.trace("Removing shutdown hook {} with priority {}", (Object)hiveMQShutdownHook.name(), (Object)hiveMQShutdownHook.priority());
        this.synchronousHooks.values().remove(hiveMQShutdownHook);
    }

    @NotNull
    public Multimap<Integer, HiveMQShutdownHook> getShutdownHooks() {
        return this.synchronousHooks;
    }

    public void runShutdownHooks() {
        this.shuttingDown.set(true);
        log.info("Shutting down HiveMQ. Please wait, this could take a while...");
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(ThreadFactoryUtil.create("shutdown-log-executor"));
        executorService.scheduleAtFixedRate(() -> log.info("Still shutting down HiveMQ. Waiting for remaining tasks to be executed. Do not shutdown HiveMQ."), 10L, 10L, TimeUnit.SECONDS);
        for (HiveMQShutdownHook runnable : this.synchronousHooks.values()) {
            log.trace(MarkerFactory.getMarker((String)"SHUTDOWN_HOOK"), "Running shutdown hook {}", (Object)runnable.name());
            runnable.run();
        }
        executorService.shutdown();
        log.info("Shutdown completed.");
    }
}

