/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.embedded.internal;

import com.google.common.base.Preconditions;
import com.hivemq.embedded.EmbeddedExtension;
import com.hivemq.embedded.EmbeddedExtensionBuilder;
import com.hivemq.embedded.internal.EmbeddedExtensionImpl;
import com.hivemq.extension.sdk.api.ExtensionMain;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;

public class EmbeddedExtensionBuilderImpl
implements EmbeddedExtensionBuilder {
    @Nullable
    private String id;
    @Nullable
    private String name;
    @Nullable
    private String version;
    @Nullable
    private String author;
    private int priority = 0;
    private int startPriority = 1000;
    @Nullable
    private ExtensionMain extensionMain;

    @Override
    @NotNull
    public EmbeddedExtensionBuilder withId(@NotNull String id) {
        this.id = id;
        return this;
    }

    @Override
    @NotNull
    public EmbeddedExtensionBuilder withName(@NotNull String name) {
        this.name = name;
        return this;
    }

    @Override
    @NotNull
    public EmbeddedExtensionBuilder withVersion(@NotNull String version) {
        this.version = version;
        return this;
    }

    @Override
    @NotNull
    public EmbeddedExtensionBuilder withAuthor(@Nullable String author) {
        this.author = author;
        return this;
    }

    @Override
    @NotNull
    public EmbeddedExtensionBuilder withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    @NotNull
    public EmbeddedExtensionBuilder withStartPriority(int startPriority) {
        this.startPriority = startPriority;
        return this;
    }

    @Override
    @NotNull
    public EmbeddedExtensionBuilder withExtensionMain(@NotNull ExtensionMain extensionMain) {
        this.extensionMain = extensionMain;
        return this;
    }

    @Override
    @NotNull
    public EmbeddedExtension build() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"id must never be null");
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"name must never be null");
        Preconditions.checkState((this.version != null ? 1 : 0) != 0, (Object)"version must never be null");
        Preconditions.checkState((this.extensionMain != null ? 1 : 0) != 0, (Object)"extensionMain must never be null");
        return new EmbeddedExtensionImpl(this.id, this.name, this.version, this.author, this.priority, this.startPriority, this.extensionMain);
    }
}

