/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.nio.file.Path;
import java.util.Objects;

public class HiveMQExtensionEvent {
    private final Change change;
    private final String extensionId;
    private final int priority;
    private final Path extensionFolder;
    private final boolean embedded;

    public HiveMQExtensionEvent(@NotNull Change change, @NotNull String extensionId, int priority, @NotNull Path extensionFolder, boolean embedded) {
        this.change = change;
        this.extensionId = extensionId;
        this.priority = priority;
        this.extensionFolder = extensionFolder;
        this.embedded = embedded;
    }

    @NotNull
    public Change getChange() {
        return this.change;
    }

    @NotNull
    public String getExtensionId() {
        return this.extensionId;
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public Path getExtensionFolder() {
        return this.extensionFolder;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public String toString() {
        return "HiveMQExtensionEvent{change=" + this.change + ", extensionId='" + this.extensionId + "', priority=" + this.priority + ", extensionFolder=" + this.extensionFolder + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveMQExtensionEvent that = (HiveMQExtensionEvent)o;
        return this.priority == that.priority && this.change == that.change && Objects.equals(this.extensionId, that.extensionId) && Objects.equals(this.extensionFolder, that.extensionFolder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.change, this.extensionId, this.priority, this.extensionFolder});
    }

    public static enum Change {
        ENABLE,
        DISABLE;

    }
}

