/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth.parameter;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.parameter.SubscriptionAuthorizerOutput;
import com.hivemq.extension.sdk.api.packets.disconnect.DisconnectReasonCode;
import com.hivemq.extension.sdk.api.packets.subscribe.SubackReasonCode;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.task.AbstractAsyncOutput;
import com.hivemq.extensions.executor.task.PluginTaskOutput;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class SubscriptionAuthorizerOutputImpl
extends AbstractAsyncOutput<SubscriptionAuthorizerOutput>
implements SubscriptionAuthorizerOutput,
PluginTaskOutput,
Supplier<SubscriptionAuthorizerOutputImpl> {
    @Nullable
    private SubackReasonCode subackReasonCode;
    @Nullable
    private String reasonString;
    @NotNull
    private DisconnectReasonCode disconnectReasonCode = DisconnectReasonCode.NOT_AUTHORIZED;
    @NotNull
    private AuthorizationState authorizationState = AuthorizationState.UNDECIDED;
    @NotNull
    private final AtomicBoolean completed = new AtomicBoolean(false);
    @NotNull
    private final AtomicBoolean authorizerPresent = new AtomicBoolean(false);

    public SubscriptionAuthorizerOutputImpl(@NotNull PluginOutPutAsyncer asyncer) {
        super(asyncer);
    }

    @Override
    @NotNull
    public SubscriptionAuthorizerOutputImpl get() {
        return this;
    }

    public void authorizeSuccessfully() {
        this.checkCompleted("authorizeSuccessfully");
        this.authorizationState = AuthorizationState.SUCCESS;
    }

    public void failAuthorization() {
        this.checkCompleted("failAuthorization");
        this.subackReasonCode = SubackReasonCode.NOT_AUTHORIZED;
        this.authorizationState = AuthorizationState.FAIL;
    }

    public void forceFailedAuthorization() {
        this.completed.set(true);
        this.subackReasonCode = SubackReasonCode.NOT_AUTHORIZED;
        this.authorizationState = AuthorizationState.FAIL;
    }

    public void failAuthorization(@NotNull SubackReasonCode reasonCode) {
        this.checkCompleted("failAuthorization");
        Preconditions.checkNotNull((Object)reasonCode, (Object)"reason code must never be null");
        if (reasonCode == SubackReasonCode.GRANTED_QOS_0 || reasonCode == SubackReasonCode.GRANTED_QOS_1 || reasonCode == SubackReasonCode.GRANTED_QOS_2) {
            throw new IllegalArgumentException("fail must use a SUBACK Error code");
        }
        this.subackReasonCode = reasonCode;
        this.authorizationState = AuthorizationState.FAIL;
    }

    public void failAuthorization(@NotNull SubackReasonCode reasonCode, @NotNull String reasonString) {
        this.checkCompleted("failAuthorization");
        Preconditions.checkNotNull((Object)reasonCode, (Object)"reason code must never be null");
        Preconditions.checkNotNull((Object)reasonString, (Object)"reason string must never be null");
        if (reasonCode == SubackReasonCode.GRANTED_QOS_0 || reasonCode == SubackReasonCode.GRANTED_QOS_1 || reasonCode == SubackReasonCode.GRANTED_QOS_2) {
            throw new IllegalArgumentException("Fail must use a SUBACK Error code");
        }
        this.subackReasonCode = reasonCode;
        this.reasonString = reasonString;
        this.authorizationState = AuthorizationState.FAIL;
    }

    public void disconnectClient() {
        this.checkCompleted("disconnectClient");
        this.disconnectReasonCode = DisconnectReasonCode.NOT_AUTHORIZED;
        this.authorizationState = AuthorizationState.DISCONNECT;
    }

    public void disconnectClient(@NotNull DisconnectReasonCode reasonCode) {
        this.checkCompleted("disconnectClient");
        Preconditions.checkNotNull((Object)reasonCode, (Object)"reason code must never be null");
        this.disconnectReasonCode = reasonCode;
        this.authorizationState = AuthorizationState.DISCONNECT;
    }

    public void disconnectClient(@NotNull DisconnectReasonCode reasonCode, @NotNull String reasonString) {
        this.checkCompleted("disconnectClient");
        Preconditions.checkNotNull((Object)reasonCode, (Object)"reason code must never be null");
        Preconditions.checkNotNull((Object)reasonString, (Object)"reason string must never be null");
        this.disconnectReasonCode = reasonCode;
        this.reasonString = reasonString;
        this.authorizationState = AuthorizationState.DISCONNECT;
    }

    public void nextExtensionOrDefault() {
        if (this.completed.get()) {
            throw new UnsupportedOperationException("nextExtensionOrDefault must not be called if authorizeSuccessfully, failAuthorization, disconnectClient or nextExtensionOrDefault has already been called or if the async output has already timed out");
        }
        this.authorizationState = AuthorizationState.CONTINUE;
    }

    @Nullable
    public SubackReasonCode getSubackReasonCode() {
        return this.subackReasonCode;
    }

    @Nullable
    public String getReasonString() {
        return this.reasonString;
    }

    @NotNull
    public DisconnectReasonCode getDisconnectReasonCode() {
        return this.disconnectReasonCode;
    }

    @NotNull
    public AuthorizationState getAuthorizationState() {
        return this.authorizationState;
    }

    private void checkCompleted(@NotNull String method) {
        if (!this.completed.compareAndSet(false, true)) {
            throw new UnsupportedOperationException(method + " must not be called if authorizeSuccessfully, failAuthorization, disconnectClient or nextExtensionOrDefault has already been called");
        }
    }

    public boolean isCompleted() {
        return this.completed.get();
    }

    public void authorizerPresent() {
        this.authorizerPresent.set(true);
    }

    public boolean isAuthorizerPresent() {
        return this.authorizerPresent.get();
    }

    public static enum AuthorizationState {
        SUCCESS,
        CONTINUE,
        FAIL,
        DISCONNECT,
        UNDECIDED;

    }
}

