/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth.parameter;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.auth.parameter.TopicPermission;
import com.hivemq.extensions.auth.parameter.InternalTopicPermission;
import org.apache.commons.lang3.StringUtils;

public class TopicPermissionImpl
implements InternalTopicPermission {
    @NotNull
    private final String topic;
    @NotNull
    private final TopicPermission.PermissionType type;
    @NotNull
    private final TopicPermission.Qos qos;
    @NotNull
    private final TopicPermission.MqttActivity activity;
    @NotNull
    private final TopicPermission.Retain retain;
    @NotNull
    private final TopicPermission.SharedSubscription sharedSubscription;
    @NotNull
    private final String sharedGroup;
    @NotNull
    private final String[] splitTopic;
    private final boolean containsWildcardCharacter;
    private final boolean isRootWildcard;
    private final boolean endsWithWildcard;

    public TopicPermissionImpl(@NotNull String topic, @NotNull TopicPermission.PermissionType type, @NotNull TopicPermission.Qos qos, @NotNull TopicPermission.MqttActivity activity, @NotNull TopicPermission.Retain retain, @NotNull TopicPermission.SharedSubscription sharedSubscription, @NotNull String sharedGroup) {
        this.topic = topic;
        this.type = type;
        this.qos = qos;
        this.activity = activity;
        this.retain = retain;
        this.sharedSubscription = sharedSubscription;
        this.sharedGroup = sharedGroup;
        String strippedPermissionTopic = StringUtils.stripEnd((String)topic, (String)"/");
        this.splitTopic = StringUtils.splitPreserveAllTokens((String)strippedPermissionTopic, (String)"/");
        this.containsWildcardCharacter = !StringUtils.containsNone((CharSequence)strippedPermissionTopic, (String)"#+");
        this.isRootWildcard = strippedPermissionTopic.contains("#");
        this.endsWithWildcard = StringUtils.endsWith((CharSequence)strippedPermissionTopic, (CharSequence)"/#");
    }

    @NotNull
    public String getTopicFilter() {
        return this.topic;
    }

    @NotNull
    public TopicPermission.PermissionType getType() {
        return this.type;
    }

    @NotNull
    public TopicPermission.Qos getQos() {
        return this.qos;
    }

    @NotNull
    public TopicPermission.MqttActivity getActivity() {
        return this.activity;
    }

    @NotNull
    public TopicPermission.Retain getPublishRetain() {
        return this.retain;
    }

    @NotNull
    public TopicPermission.SharedSubscription getSharedSubscription() {
        return this.sharedSubscription;
    }

    @NotNull
    public String getSharedGroup() {
        return this.sharedGroup;
    }

    @Override
    @NotNull
    public String[] getSplitTopic() {
        return this.splitTopic;
    }

    @Override
    public boolean containsWildcardCharacter() {
        return this.containsWildcardCharacter;
    }

    @Override
    public boolean isRootWildcard() {
        return this.isRootWildcard;
    }

    @Override
    public boolean endsWithWildcard() {
        return this.endsWithWildcard;
    }
}

