/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.ClientContext;
import com.hivemq.extension.sdk.api.interceptor.Interceptor;
import com.hivemq.extension.sdk.api.interceptor.disconnect.DisconnectInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.disconnect.DisconnectOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pingreq.PingReqInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pingresp.PingRespOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.puback.PubackInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.puback.PubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.PubcompInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.PubcompOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.publish.PublishInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.publish.PublishOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrec.PubrecInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrec.PubrecOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrel.PubrelInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrel.PubrelOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.suback.SubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.subscribe.SubscribeInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.unsuback.UnsubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.unsubscribe.UnsubscribeInboundInterceptor;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.task.AbstractOutput;
import java.util.List;

public class ClientContextPluginImpl
extends AbstractOutput
implements ClientContext {
    @NotNull
    private final ClassLoader pluginClassloader;
    @NotNull
    private final ClientContextImpl clientContext;

    public ClientContextPluginImpl(@NotNull ClassLoader pluginClassloader, @NotNull ClientContextImpl clientContext) {
        this.pluginClassloader = pluginClassloader;
        this.clientContext = clientContext;
    }

    public void addPublishInboundInterceptor(@NotNull PublishInboundInterceptor interceptor) {
        this.clientContext.addPublishInboundInterceptor((PublishInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPublishOutboundInterceptor(@NotNull PublishOutboundInterceptor interceptor) {
        this.clientContext.addPublishOutboundInterceptor((PublishOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPubackInboundInterceptor(@NotNull PubackInboundInterceptor interceptor) {
        this.clientContext.addPubackInboundInterceptor((PubackInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPubackOutboundInterceptor(@NotNull PubackOutboundInterceptor interceptor) {
        this.clientContext.addPubackOutboundInterceptor((PubackOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPubrecInboundInterceptor(@NotNull PubrecInboundInterceptor interceptor) {
        this.clientContext.addPubrecInboundInterceptor((PubrecInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPubrecOutboundInterceptor(@NotNull PubrecOutboundInterceptor interceptor) {
        this.clientContext.addPubrecOutboundInterceptor((PubrecOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPubrelInboundInterceptor(@NotNull PubrelInboundInterceptor interceptor) {
        this.clientContext.addPubrelInboundInterceptor((PubrelInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPubrelOutboundInterceptor(@NotNull PubrelOutboundInterceptor interceptor) {
        this.clientContext.addPubrelOutboundInterceptor((PubrelOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPubcompInboundInterceptor(@NotNull PubcompInboundInterceptor interceptor) {
        this.clientContext.addPubcompInboundInterceptor((PubcompInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPubcompOutboundInterceptor(@NotNull PubcompOutboundInterceptor interceptor) {
        this.clientContext.addPubcompOutboundInterceptor((PubcompOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addSubscribeInboundInterceptor(@NotNull SubscribeInboundInterceptor interceptor) {
        this.clientContext.addSubscribeInboundInterceptor((SubscribeInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addSubackOutboundInterceptor(@NotNull SubackOutboundInterceptor interceptor) {
        this.clientContext.addSubackOutboundInterceptor((SubackOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addUnsubscribeInboundInterceptor(@NotNull UnsubscribeInboundInterceptor interceptor) {
        this.clientContext.addUnsubscribeInboundInterceptor((UnsubscribeInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addUnsubackOutboundInterceptor(@NotNull UnsubackOutboundInterceptor interceptor) {
        this.clientContext.addUnsubackOutboundInterceptor((UnsubackOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addDisconnectInboundInterceptor(@NotNull DisconnectInboundInterceptor interceptor) {
        this.clientContext.addDisconnectInboundInterceptor((DisconnectInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addDisconnectOutboundInterceptor(@NotNull DisconnectOutboundInterceptor interceptor) {
        this.clientContext.addDisconnectOutboundInterceptor((DisconnectOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPingReqInboundInterceptor(@NotNull PingReqInboundInterceptor interceptor) {
        this.clientContext.addPingReqInboundInterceptor((PingReqInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void addPingRespOutboundInterceptor(@NotNull PingRespOutboundInterceptor interceptor) {
        this.clientContext.addPingRespOutboundInterceptor((PingRespOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePublishInboundInterceptor(@NotNull PublishInboundInterceptor interceptor) {
        this.clientContext.removePublishInboundInterceptor((PublishInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePublishOutboundInterceptor(@NotNull PublishOutboundInterceptor interceptor) {
        this.clientContext.removePublishOutboundInterceptor((PublishOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePubackInboundInterceptor(@NotNull PubackInboundInterceptor interceptor) {
        this.clientContext.removePubackInboundInterceptor((PubackInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePubackOutboundInterceptor(@NotNull PubackOutboundInterceptor interceptor) {
        this.clientContext.removePubackOutboundInterceptor((PubackOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePubrecInboundInterceptor(@NotNull PubrecInboundInterceptor interceptor) {
        this.clientContext.removePubrecInboundInterceptor((PubrecInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePubrecOutboundInterceptor(@NotNull PubrecOutboundInterceptor interceptor) {
        this.clientContext.removePubrecOutboundInterceptor((PubrecOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePubrelInboundInterceptor(@NotNull PubrelInboundInterceptor interceptor) {
        this.clientContext.removePubrelInboundInterceptor((PubrelInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePubrelOutboundInterceptor(@NotNull PubrelOutboundInterceptor interceptor) {
        this.clientContext.removePubrelOutboundInterceptor((PubrelOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePubcompInboundInterceptor(@NotNull PubcompInboundInterceptor interceptor) {
        this.clientContext.removePubcompInboundInterceptor((PubcompInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePubcompOutboundInterceptor(@NotNull PubcompOutboundInterceptor interceptor) {
        this.clientContext.removePubcompOutboundInterceptor((PubcompOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removeSubscribeInboundInterceptor(@NotNull SubscribeInboundInterceptor interceptor) {
        this.clientContext.removeSubscribeInboundInterceptor((SubscribeInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removeSubackOutboundInterceptor(@NotNull SubackOutboundInterceptor interceptor) {
        this.clientContext.removeSubackOutboundInterceptor((SubackOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removeUnsubscribeInboundInterceptor(@NotNull UnsubscribeInboundInterceptor interceptor) {
        this.clientContext.removeUnsubscribeInboundInterceptor((UnsubscribeInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removeUnsubackOutboundInterceptor(@NotNull UnsubackOutboundInterceptor interceptor) {
        this.clientContext.removeUnsubackOutboundInterceptor((UnsubackOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removeDisconnectInboundInterceptor(@NotNull DisconnectInboundInterceptor interceptor) {
        this.clientContext.removeDisconnectInboundInterceptor((DisconnectInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removeDisconnectOutboundInterceptor(@NotNull DisconnectOutboundInterceptor interceptor) {
        this.clientContext.removeDisconnectOutboundInterceptor((DisconnectOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePingReqInboundInterceptor(@NotNull PingReqInboundInterceptor interceptor) {
        this.clientContext.removePingReqInboundInterceptor((PingReqInboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    public void removePingRespOutboundInterceptor(@NotNull PingRespOutboundInterceptor interceptor) {
        this.clientContext.removePingRespOutboundInterceptor((PingRespOutboundInterceptor)Preconditions.checkNotNull((Object)interceptor, (Object)"The interceptor must never be null"));
    }

    @NotNull
    public @NotNull List<@NotNull Interceptor> getAllInterceptors() {
        return this.clientContext.getAllInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PublishInboundInterceptor> getPublishInboundInterceptors() {
        return this.clientContext.getPublishInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PublishOutboundInterceptor> getPublishOutboundInterceptors() {
        return this.clientContext.getPublishOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PubackInboundInterceptor> getPubackInboundInterceptors() {
        return this.clientContext.getPubackInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PubackOutboundInterceptor> getPubackOutboundInterceptors() {
        return this.clientContext.getPubackOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PubrecInboundInterceptor> getPubrecInboundInterceptors() {
        return this.clientContext.getPubrecInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PubrecOutboundInterceptor> getPubrecOutboundInterceptors() {
        return this.clientContext.getPubrecOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PubrelInboundInterceptor> getPubrelInboundInterceptors() {
        return this.clientContext.getPubrelInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PubrelOutboundInterceptor> getPubrelOutboundInterceptors() {
        return this.clientContext.getPubrelOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PubcompInboundInterceptor> getPubcompInboundInterceptors() {
        return this.clientContext.getPubcompInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PubcompOutboundInterceptor> getPubcompOutboundInterceptors() {
        return this.clientContext.getPubcompOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull SubscribeInboundInterceptor> getSubscribeInboundInterceptors() {
        return this.clientContext.getSubscribeInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull SubackOutboundInterceptor> getSubackOutboundInterceptors() {
        return this.clientContext.getSubackOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull UnsubscribeInboundInterceptor> getUnsubscribeInboundInterceptors() {
        return this.clientContext.getUnsubscribeInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull UnsubackOutboundInterceptor> getUnsubackOutboundInterceptors() {
        return this.clientContext.getUnsubackOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull DisconnectInboundInterceptor> getDisconnectInboundInterceptors() {
        return this.clientContext.getDisconnectInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull DisconnectOutboundInterceptor> getDisconnectOutboundInterceptors() {
        return this.clientContext.getDisconnectOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PingReqInboundInterceptor> getPingReqInboundInterceptors() {
        return this.clientContext.getPingReqInboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public @NotNull List<@NotNull PingRespOutboundInterceptor> getPingRespOutboundInterceptors() {
        return this.clientContext.getPingRespOutboundInterceptorsOfExtension(this.pluginClassloader);
    }

    @NotNull
    public ModifiableDefaultPermissions getDefaultPermissions() {
        return this.clientContext.getDefaultPermissions();
    }
}

