/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.interceptor.publish.parameter;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.interceptor.publish.parameter.PublishOutboundOutput;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.task.AbstractAsyncOutput;
import com.hivemq.extensions.interceptor.publish.parameter.PublishOutboundInputImpl;
import com.hivemq.extensions.packets.publish.ModifiableOutboundPublishImpl;
import java.util.concurrent.atomic.AtomicBoolean;

public class PublishOutboundOutputImpl
extends AbstractAsyncOutput<PublishOutboundOutput>
implements PublishOutboundOutput {
    @NotNull
    private final ModifiableOutboundPublishImpl publishPacket;
    @NotNull
    private final AtomicBoolean preventDelivery = new AtomicBoolean(false);

    public PublishOutboundOutputImpl(@NotNull PluginOutPutAsyncer asyncer, @NotNull ModifiableOutboundPublishImpl publishPacket) {
        super(asyncer);
        this.publishPacket = publishPacket;
    }

    @NotNull
    public ModifiableOutboundPublishImpl getPublishPacket() {
        return this.publishPacket;
    }

    public void preventPublishDelivery() {
        this.checkPrevented();
    }

    public void forciblyPreventPublishDelivery() {
        this.preventDelivery.set(true);
    }

    public boolean isPreventDelivery() {
        return this.preventDelivery.get();
    }

    private void checkPrevented() {
        if (!this.preventDelivery.compareAndSet(false, true)) {
            throw new UnsupportedOperationException("preventPublishDelivery must not be called more than once");
        }
    }

    @NotNull
    public PublishOutboundOutputImpl update(@NotNull PublishOutboundInputImpl input) {
        return new PublishOutboundOutputImpl(this.asyncer, this.publishPacket.update(input.getPublishPacket()));
    }
}

