/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.iteration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.iteration.BucketChunkResult;
import com.hivemq.extensions.iteration.ChunkCursor;
import com.hivemq.extensions.iteration.MultipleChunkResult;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class Chunker {
    private final int bucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();

    @Inject
    public Chunker() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public <T> @NotNull ListenableFuture<MultipleChunkResult<Map<String, @NotNull T>>> getAllLocalChunk(@NotNull ChunkCursor cursor, int maxChunkSize, @NotNull SingleWriterCall<T> singleWriterCall) {
        try {
            Preconditions.checkNotNull((Object)cursor, (Object)"Cursor must not be null");
            Preconditions.checkNotNull(singleWriterCall, (Object)"Single writer call must not be null");
            // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull ImmutableList.Builder builder = ImmutableList.builder();
            int maxResults = maxChunkSize / (this.bucketCount - cursor.getFinishedBuckets().size());
            for (int i = 0; i < this.bucketCount; ++i) {
                if (cursor.getFinishedBuckets().contains(i)) continue;
                String lastKey = cursor.getLastKeys().get(i);
                builder.add(singleWriterCall.call(i, lastKey, maxResults));
            }
            return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)builder.build()), allBucketsResult -> {
                Preconditions.checkNotNull((Object)allBucketsResult, (Object)"Iteration result from all buckets cannot be null");
                ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
                for (BucketChunkResult bucketResult : allBucketsResult) {
                    resultBuilder.put((Object)bucketResult.getBucketIndex(), (Object)bucketResult);
                }
                for (Integer finishedBucketId : cursor.getFinishedBuckets()) {
                    resultBuilder.put((Object)finishedBucketId, new BucketChunkResult(Map.of(), true, cursor.getLastKeys().get(finishedBucketId), finishedBucketId));
                }
                return new MultipleChunkResult(resultBuilder.build());
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable throwable) {
            return Futures.immediateFailedFuture((Throwable)throwable);
        }
    }

    public static interface SingleWriterCall<T> {
        public ListenableFuture<@NotNull BucketChunkResult<Map<String, T>>> call(int var1, @NotNull String var2, int var3);
    }
}

