/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.disconnect;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.disconnect.DisconnectPacket;
import com.hivemq.extension.sdk.api.packets.disconnect.DisconnectReasonCode;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import java.util.Objects;
import java.util.Optional;

public class DisconnectPacketImpl
implements DisconnectPacket {
    @NotNull
    final DisconnectReasonCode reasonCode;
    @Nullable
    final String reasonString;
    final long sessionExpiryInterval;
    @Nullable
    final String serverReference;
    @NotNull
    final UserPropertiesImpl userProperties;

    public DisconnectPacketImpl(@NotNull DisconnectReasonCode reasonCode, @Nullable String reasonString, long sessionExpiryInterval, @Nullable String serverReference, @NotNull UserPropertiesImpl userProperties) {
        this.reasonCode = reasonCode;
        this.reasonString = reasonString;
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.serverReference = serverReference;
        this.userProperties = userProperties;
    }

    public DisconnectPacketImpl(@NotNull DISCONNECT disconnect) {
        this(((Mqtt5DisconnectReasonCode)disconnect.getReasonCode()).toDisconnectReasonCode(), disconnect.getReasonString(), disconnect.getSessionExpiryInterval(), disconnect.getServerReference(), UserPropertiesImpl.of(disconnect.getUserProperties().asList()));
    }

    @NotNull
    public DisconnectReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    @NotNull
    public Optional<Long> getSessionExpiryInterval() {
        return this.sessionExpiryInterval == Long.MAX_VALUE ? Optional.empty() : Optional.of(this.sessionExpiryInterval);
    }

    @NotNull
    public Optional<String> getServerReference() {
        return Optional.ofNullable(this.serverReference);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisconnectPacketImpl)) {
            return false;
        }
        DisconnectPacketImpl that = (DisconnectPacketImpl)o;
        return this.reasonCode == that.reasonCode && Objects.equals(this.reasonString, that.reasonString) && this.sessionExpiryInterval == that.sessionExpiryInterval && Objects.equals(this.serverReference, that.serverReference) && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.reasonCode, this.reasonString, this.sessionExpiryInterval, this.serverReference, this.userProperties);
    }
}

