/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.subscribe;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.subscribe.ModifiableSubscription;
import com.hivemq.extension.sdk.api.packets.subscribe.RetainHandling;
import com.hivemq.extensions.packets.subscribe.SubscriptionImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.persistence.clientsession.SharedSubscriptionService;
import com.hivemq.util.Topics;

@ThreadSafe
public class ModifiableSubscriptionImpl
implements ModifiableSubscription {
    @NotNull
    private String topicFilter;
    @NotNull
    private Qos qos;
    @NotNull
    private RetainHandling retainHandling;
    private boolean retainAsPublished;
    private boolean noLocal;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiableSubscriptionImpl(@NotNull SubscriptionImpl subscription, @NotNull FullConfigurationService configurationService) {
        this.topicFilter = subscription.topicFilter;
        this.qos = subscription.qos;
        this.retainHandling = subscription.retainHandling;
        this.retainAsPublished = subscription.retainAsPublished;
        this.noLocal = subscription.noLocal;
        this.configurationService = configurationService;
    }

    @NotNull
    public String getTopicFilter() {
        return this.topicFilter;
    }

    public void setTopicFilter(@NotNull String topicFilter) {
        Preconditions.checkNotNull((Object)topicFilter, (Object)"Topic filter must never be null");
        Preconditions.checkArgument((topicFilter.length() <= this.configurationService.restrictionsConfiguration().maxTopicLength() ? 1 : 0) != 0, (Object)("Topic filter length must not exceed '" + this.configurationService.restrictionsConfiguration().maxTopicLength() + "' characters, but has '" + topicFilter.length() + "' characters"));
        Preconditions.checkArgument((this.configurationService.mqttConfiguration().wildcardSubscriptionsEnabled() || !Topics.containsWildcard(topicFilter) ? 1 : 0) != 0, (Object)"Wildcard characters '+' or '#' are not allowed");
        if (this.topicFilter.equals(topicFilter)) {
            return;
        }
        boolean shared = Topics.isSharedSubscriptionTopic(topicFilter);
        Preconditions.checkArgument((!this.noLocal || !shared ? 1 : 0) != 0, (Object)"Shared subscription is not allowed with no local flag set to true");
        if (shared) {
            Preconditions.checkArgument((boolean)this.configurationService.mqttConfiguration().sharedSubscriptionsEnabled(), (Object)"Shared subscriptions not allowed");
            SharedSubscriptionService.SharedSubscription sharedSubscription = Topics.checkForSharedSubscription(topicFilter);
            if (sharedSubscription != null) {
                Preconditions.checkArgument((!sharedSubscription.getTopicFilter().isEmpty() ? 1 : 0) != 0, (Object)"Shared subscription topic must not be empty");
            }
        }
        if (!Topics.isValidToSubscribe(topicFilter)) {
            throw new IllegalArgumentException("The topic filter (" + topicFilter + ") is invalid for subscriptions");
        }
        if (!PluginBuilderUtil.isValidUtf8String(topicFilter, this.configurationService.securityConfiguration().validateUTF8())) {
            throw new IllegalArgumentException("The topic filter (" + topicFilter + ") is UTF-8 malformed");
        }
        this.topicFilter = topicFilter;
        this.modified = true;
    }

    @NotNull
    public Qos getQos() {
        return this.qos;
    }

    public void setQos(@NotNull Qos qos) {
        PluginBuilderUtil.checkQos(qos, this.configurationService.mqttConfiguration().maximumQos().getQosNumber());
        if (this.qos.getQosNumber() == qos.getQosNumber()) {
            return;
        }
        this.qos = qos;
        this.modified = true;
    }

    @NotNull
    public RetainHandling getRetainHandling() {
        return this.retainHandling;
    }

    public void setRetainHandling(@NotNull RetainHandling retainHandling) {
        Preconditions.checkNotNull((Object)retainHandling, (Object)"Retain handling must never be null");
        if (this.retainHandling.getCode() == retainHandling.getCode()) {
            return;
        }
        this.retainHandling = retainHandling;
        this.modified = true;
    }

    public boolean getRetainAsPublished() {
        return this.retainAsPublished;
    }

    public void setRetainAsPublished(boolean retainAsPublished) {
        if (this.retainAsPublished == retainAsPublished) {
            return;
        }
        this.retainAsPublished = retainAsPublished;
        this.modified = true;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        Preconditions.checkArgument((!noLocal || !Topics.isSharedSubscriptionTopic(this.topicFilter) ? 1 : 0) != 0, (Object)"No local is not allowed for shared subscriptions");
        if (this.noLocal == noLocal) {
            return;
        }
        this.noLocal = noLocal;
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    @NotNull
    public SubscriptionImpl copy() {
        return new SubscriptionImpl(this.topicFilter, this.qos, this.retainHandling, this.retainAsPublished, this.noLocal);
    }

    @NotNull
    public ModifiableSubscriptionImpl update(@NotNull SubscriptionImpl subscription) {
        return new ModifiableSubscriptionImpl(subscription, this.configurationService);
    }
}

