/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.subscribe;

import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.subscribe.SubscribePacket;
import com.hivemq.extension.sdk.api.packets.subscribe.Subscription;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.extensions.packets.subscribe.SubscriptionImpl;
import com.hivemq.mqtt.message.subscribe.SUBSCRIBE;
import com.hivemq.mqtt.message.subscribe.Topic;
import java.util.Objects;
import java.util.Optional;

public class SubscribePacketImpl
implements SubscribePacket {
    @NotNull
    final ImmutableList<SubscriptionImpl> subscriptions;
    @NotNull
    final UserPropertiesImpl userProperties;
    final int subscriptionIdentifier;
    final int packetIdentifier;

    public SubscribePacketImpl(@NotNull ImmutableList<SubscriptionImpl> subscriptions, @NotNull UserPropertiesImpl userProperties, int subscriptionIdentifier, int packetIdentifier) {
        this.subscriptions = subscriptions;
        this.userProperties = userProperties;
        this.subscriptionIdentifier = subscriptionIdentifier;
        this.packetIdentifier = packetIdentifier;
    }

    public SubscribePacketImpl(@NotNull SUBSCRIBE subscribe) {
        ImmutableList.Builder builder = ImmutableList.builder();
        subscribe.getTopics().forEach(topic -> builder.add((Object)new SubscriptionImpl((Topic)topic)));
        this.subscriptions = builder.build();
        this.userProperties = UserPropertiesImpl.of(subscribe.getUserProperties().asList());
        this.subscriptionIdentifier = subscribe.getSubscriptionIdentifier();
        this.packetIdentifier = subscribe.getPacketIdentifier();
    }

    @NotNull
    public ImmutableList<Subscription> getSubscriptions() {
        return ImmutableList.copyOf(this.subscriptions);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    @NotNull
    public Optional<Integer> getSubscriptionIdentifier() {
        if (this.subscriptionIdentifier == -1) {
            return Optional.empty();
        }
        return Optional.of(this.subscriptionIdentifier);
    }

    public int getPacketId() {
        return this.packetIdentifier;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscribePacketImpl)) {
            return false;
        }
        SubscribePacketImpl that = (SubscribePacketImpl)o;
        return this.subscriptions.equals(that.subscriptions) && this.userProperties.equals(that.userProperties) && this.subscriptionIdentifier == that.subscriptionIdentifier && this.packetIdentifier == that.packetIdentifier;
    }

    public int hashCode() {
        return Objects.hash(this.subscriptions, this.userProperties, this.subscriptionIdentifier, this.packetIdentifier);
    }
}

