/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.builder;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.subscribe.Subscription;
import com.hivemq.extension.sdk.api.services.builder.TopicSubscriptionBuilder;
import com.hivemq.extension.sdk.api.services.exception.DoNotImplementException;
import com.hivemq.extension.sdk.api.services.subscription.TopicSubscription;
import com.hivemq.extensions.packets.subscribe.SubscriptionImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.extensions.services.subscription.TopicSubscriptionImpl;
import com.hivemq.persistence.clientsession.SharedSubscriptionService;
import com.hivemq.util.Topics;
import javax.inject.Inject;

public class TopicSubscriptionBuilderImpl
implements TopicSubscriptionBuilder {
    private static final int MAX_SUBSCRIPTION_IDENTIFIER = 0xFFFFFFF;
    @Nullable
    private String topicFilter;
    @NotNull
    private Qos qos = Qos.AT_MOST_ONCE;
    private boolean retainAsPublished;
    private boolean noLocal;
    private boolean shared = false;
    @Nullable
    private Integer subscriptionIdentifier;
    @NotNull
    private final MqttConfigurationService mqttConfig;
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfig;
    @NotNull
    private final SecurityConfigurationService securityConfigurationService;

    @Inject
    public TopicSubscriptionBuilderImpl(@NotNull FullConfigurationService configurationService) {
        this.mqttConfig = configurationService.mqttConfiguration();
        this.restrictionsConfig = configurationService.restrictionsConfiguration();
        this.securityConfigurationService = configurationService.securityConfiguration();
    }

    @NotNull
    public TopicSubscriptionBuilder fromSubscription(@NotNull Subscription subscription) {
        Preconditions.checkNotNull((Object)subscription, (Object)"Subscription must never be null");
        if (!(subscription instanceof SubscriptionImpl)) {
            throw new DoNotImplementException(Subscription.class.getSimpleName());
        }
        this.topicFilter = subscription.getTopicFilter();
        this.qos = subscription.getQos();
        this.retainAsPublished = subscription.getRetainAsPublished();
        this.noLocal = subscription.getNoLocal();
        return this;
    }

    @NotNull
    public TopicSubscriptionBuilder topicFilter(@NotNull String topicFilter) {
        Preconditions.checkNotNull((Object)topicFilter, (Object)"Topic filter must never be null");
        Preconditions.checkArgument((topicFilter.length() <= this.restrictionsConfig.maxTopicLength() ? 1 : 0) != 0, (Object)("Topic filter length must not exceed '" + this.restrictionsConfig.maxTopicLength() + "' characters, but has '" + topicFilter.length() + "' characters"));
        Preconditions.checkArgument((this.mqttConfig.wildcardSubscriptionsEnabled() || !Topics.containsWildcard(topicFilter) ? 1 : 0) != 0, (Object)"Wildcard characters '+' or '#' are not allowed");
        this.shared = Topics.isSharedSubscriptionTopic(topicFilter);
        if (this.shared) {
            Preconditions.checkArgument((boolean)this.mqttConfig.sharedSubscriptionsEnabled(), (Object)"Shared subscriptions not allowed");
            SharedSubscriptionService.SharedSubscription sharedSubscription = Topics.checkForSharedSubscription(topicFilter);
            if (sharedSubscription != null) {
                Preconditions.checkArgument((!sharedSubscription.getTopicFilter().isEmpty() ? 1 : 0) != 0, (Object)"Shared subscription topic must not be empty");
            }
        }
        if (!Topics.isValidToSubscribe(topicFilter)) {
            throw new IllegalArgumentException("The topic filter (" + topicFilter + ") is invalid for subscriptions");
        }
        if (!PluginBuilderUtil.isValidUtf8String(topicFilter, this.securityConfigurationService.validateUTF8())) {
            throw new IllegalArgumentException("The topic filter (" + topicFilter + ") is UTF-8 malformed");
        }
        this.topicFilter = topicFilter;
        return this;
    }

    @NotNull
    public TopicSubscriptionBuilder qos(@NotNull Qos qos) {
        Preconditions.checkNotNull((Object)qos, (Object)"Qos must never be null");
        this.qos = qos;
        return this;
    }

    @NotNull
    public TopicSubscriptionBuilder retainAsPublished(boolean retainAsPublished) {
        this.retainAsPublished = retainAsPublished;
        return this;
    }

    @NotNull
    public TopicSubscriptionBuilder noLocal(boolean noLocal) {
        this.noLocal = noLocal;
        return this;
    }

    @NotNull
    public TopicSubscriptionBuilder subscriptionIdentifier(int subscriptionIdentifier) {
        Preconditions.checkArgument((boolean)this.mqttConfig.subscriptionIdentifierEnabled(), (Object)"Subscription identifier are not allowed");
        Preconditions.checkArgument((subscriptionIdentifier >= 1 && subscriptionIdentifier <= 0xFFFFFFF ? 1 : 0) != 0, (Object)"Subscription identifier must be between 1 and 268,435,455");
        this.subscriptionIdentifier = subscriptionIdentifier;
        return this;
    }

    @NotNull
    public TopicSubscription build() {
        Preconditions.checkNotNull((Object)this.topicFilter, (Object)"Topic filter must never be null");
        if (this.shared) {
            Preconditions.checkArgument((!this.noLocal ? 1 : 0) != 0, (Object)"No local for shared subscriptions is not allowed");
        }
        return new TopicSubscriptionImpl(this.topicFilter, this.qos, this.retainAsPublished, this.noLocal, this.subscriptionIdentifier);
    }
}

