/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.executor;

import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.services.executor.ManagedPluginExecutorShutdownHook;
import com.hivemq.util.ThreadFactoryUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GlobalManagedExtensionExecutorService
implements ScheduledExecutorService {
    private static final Logger log = LoggerFactory.getLogger(GlobalManagedExtensionExecutorService.class);
    @NotNull
    private final ShutdownHooks shutdownHooks;
    @Nullable
    private ScheduledExecutorService scheduledExecutorService;
    @Nullable
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    @Inject
    public GlobalManagedExtensionExecutorService(@NotNull ShutdownHooks shutdownHooks) {
        this.shutdownHooks = shutdownHooks;
    }

    @PostConstruct
    public void postConstruct() {
        ThreadFactory threadFactory = ThreadFactoryUtil.create("managed-extension-executor-%d");
        int corePoolSize = InternalConfigurations.MANAGED_EXTENSION_THREAD_POOL_THREADS_COUNT.get();
        int keepAlive = InternalConfigurations.MANAGED_EXTENSION_THREAD_POOL_KEEP_ALIVE_SEC.get();
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        log.debug("Set extension executor thread pool size to {}", (Object)corePoolSize);
        this.scheduledThreadPoolExecutor.setKeepAliveTime(keepAlive, TimeUnit.SECONDS);
        log.debug("Set extension executor thread pool keep-alive to {} seconds", (Object)keepAlive);
        this.scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        this.scheduledExecutorService = this.scheduledThreadPoolExecutor;
        this.shutdownHooks.add(new ManagedPluginExecutorShutdownHook(this, InternalConfigurations.MANAGED_EXTENSION_EXECUTOR_SHUTDOWN_TIMEOUT_SEC.get()));
    }

    public int getCorePoolSize() {
        return Objects.requireNonNull(this.scheduledThreadPoolExecutor).getCorePoolSize();
    }

    public int getMaxPoolSize() {
        return Objects.requireNonNull(this.scheduledThreadPoolExecutor).getMaximumPoolSize();
    }

    public int getCurrentPoolSize() {
        return Objects.requireNonNull(this.scheduledThreadPoolExecutor).getPoolSize();
    }

    public long getKeepAliveSeconds() {
        return Objects.requireNonNull(this.scheduledThreadPoolExecutor).getKeepAliveTime(TimeUnit.SECONDS);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        return Objects.requireNonNull(this.scheduledExecutorService).schedule(command, delay, unit);
    }

    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        return Objects.requireNonNull(this.scheduledExecutorService).schedule(callable, delay, unit);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        return Objects.requireNonNull(this.scheduledExecutorService).scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
        return Objects.requireNonNull(this.scheduledExecutorService).scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        Objects.requireNonNull(this.scheduledExecutorService).shutdown();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return Objects.requireNonNull(this.scheduledExecutorService).shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return Objects.requireNonNull(this.scheduledExecutorService).isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return Objects.requireNonNull(this.scheduledExecutorService).isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return Objects.requireNonNull(this.scheduledExecutorService).awaitTermination(timeout, unit);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        return Objects.requireNonNull(this.scheduledExecutorService).submit(task);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, @NotNull T result) {
        return Objects.requireNonNull(this.scheduledExecutorService).submit(task, result);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        return Objects.requireNonNull(this.scheduledExecutorService).submit(task);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return Objects.requireNonNull(this.scheduledExecutorService).invokeAll(tasks);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return Objects.requireNonNull(this.scheduledExecutorService).invokeAll(tasks, timeout, unit);
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return Objects.requireNonNull(this.scheduledExecutorService).invokeAny(tasks);
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return Objects.requireNonNull(this.scheduledExecutorService).invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Objects.requireNonNull(this.scheduledExecutorService).execute(command);
    }
}

