/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.executor;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.util.concurrent.CompletableFuture;

public class WrappedRunnableWithResult<T>
implements Runnable {
    @NotNull
    private final Runnable runnable;
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final CompletableFuture<T> future;
    @NotNull
    private final T result;

    WrappedRunnableWithResult(@NotNull Runnable runnable, @NotNull ClassLoader classLoader, @NotNull CompletableFuture<T> future, @NotNull T result) {
        this.runnable = runnable;
        this.classLoader = classLoader;
        this.future = future;
        this.result = result;
    }

    @Override
    public void run() {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.runnable.run();
            this.future.complete(this.result);
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }
}

