/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.publish;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.services.exception.DoNotImplementException;
import com.hivemq.extension.sdk.api.services.general.IterationCallback;
import com.hivemq.extension.sdk.api.services.publish.RetainedMessageStore;
import com.hivemq.extension.sdk.api.services.publish.RetainedPublish;
import com.hivemq.extensions.ListenableFutureConverter;
import com.hivemq.extensions.iteration.AllItemsFetchCallback;
import com.hivemq.extensions.iteration.AllItemsItemCallback;
import com.hivemq.extensions.iteration.AsyncIterator;
import com.hivemq.extensions.iteration.AsyncIteratorFactory;
import com.hivemq.extensions.iteration.ChunkCursor;
import com.hivemq.extensions.iteration.MultipleChunkResult;
import com.hivemq.extensions.services.PluginServiceRateLimitService;
import com.hivemq.extensions.services.executor.GlobalManagedExtensionExecutorService;
import com.hivemq.extensions.services.publish.RetainedPublishImpl;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.inject.Inject;

@LazySingleton
public class RetainedMessageStoreImpl
implements RetainedMessageStore {
    @NotNull
    private final RetainedMessagePersistence retainedMessagePersistence;
    @NotNull
    private final GlobalManagedExtensionExecutorService globalManagedExtensionExecutorService;
    @NotNull
    private final PluginServiceRateLimitService pluginServiceRateLimitService;
    @NotNull
    private final AsyncIteratorFactory asyncIteratorFactory;

    @Inject
    public RetainedMessageStoreImpl(@NotNull RetainedMessagePersistence retainedMessagePersistence, @NotNull GlobalManagedExtensionExecutorService managedExtensionExecurotrService, @NotNull PluginServiceRateLimitService pluginServiceRateLimitService, @NotNull AsyncIteratorFactory asyncIteratorFactory) {
        this.retainedMessagePersistence = retainedMessagePersistence;
        this.globalManagedExtensionExecutorService = managedExtensionExecurotrService;
        this.pluginServiceRateLimitService = pluginServiceRateLimitService;
        this.asyncIteratorFactory = asyncIteratorFactory;
    }

    @NotNull
    public CompletableFuture<Optional<RetainedPublish>> getRetainedMessage(@NotNull String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"A topic must never be null");
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        ListenableFuture<RetainedMessage> retainedMessageFuture = this.retainedMessagePersistence.get(topic);
        return ListenableFutureConverter.toCompletable(retainedMessageFuture, r -> r == null ? Optional.empty() : Optional.of(new RetainedPublishImpl(topic, (RetainedMessage)r)), false, this.globalManagedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<Void> remove(@NotNull String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"A topic must never be null");
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        return ListenableFutureConverter.toCompletable(this.retainedMessagePersistence.remove(topic), this.globalManagedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<Void> clear() {
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        return ListenableFutureConverter.toCompletable(this.retainedMessagePersistence.clear(), this.globalManagedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<Void> addOrReplace(@NotNull RetainedPublish retainedPublish) {
        Preconditions.checkNotNull((Object)retainedPublish, (Object)"A retained publish must never be null");
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        if (!(retainedPublish instanceof RetainedPublishImpl)) {
            return CompletableFuture.failedFuture((Throwable)new DoNotImplementException(RetainedPublish.class.getSimpleName()));
        }
        ListenableFuture<Void> persist = this.retainedMessagePersistence.persist(retainedPublish.getTopic(), RetainedPublishImpl.convert((RetainedPublishImpl)retainedPublish));
        return ListenableFutureConverter.toCompletable(persist, this.globalManagedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<Void> iterateAllRetainedMessages(@NotNull IterationCallback<RetainedPublish> callback) {
        return this.iterateAllRetainedMessages(callback, this.globalManagedExtensionExecutorService);
    }

    @NotNull
    public CompletableFuture<Void> iterateAllRetainedMessages(@NotNull IterationCallback<RetainedPublish> callback, @NotNull Executor callbackExecutor) {
        Preconditions.checkNotNull(callback, (Object)"Callback cannot be null");
        Preconditions.checkNotNull((Object)callbackExecutor, (Object)"Callback executor cannot be null");
        if (this.pluginServiceRateLimitService.rateLimitExceeded()) {
            return CompletableFuture.failedFuture((Throwable)PluginServiceRateLimitService.RATE_LIMIT_EXCEEDED_EXCEPTION);
        }
        AllRetainedPublishesFetchCallBack fetchCallback = new AllRetainedPublishesFetchCallBack(this.retainedMessagePersistence);
        AsyncIterator<RetainedPublish> asyncIterator = this.asyncIteratorFactory.createIterator(fetchCallback, new AllItemsItemCallback<RetainedPublish>(callbackExecutor, callback));
        asyncIterator.fetchAndIterate();
        SettableFuture settableFuture = SettableFuture.create();
        asyncIterator.getFinishedFuture().whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                settableFuture.setException(throwable);
            } else {
                settableFuture.set(null);
            }
        });
        return ListenableFutureConverter.toCompletable(settableFuture, this.globalManagedExtensionExecutorService);
    }

    static class AllRetainedPublishesFetchCallBack
    extends AllItemsFetchCallback<RetainedPublish, Map<String, RetainedMessage>> {
        @NotNull
        private final RetainedMessagePersistence retainedMessagePersistence;

        AllRetainedPublishesFetchCallBack(@NotNull RetainedMessagePersistence retainedMessagePersistence) {
            this.retainedMessagePersistence = retainedMessagePersistence;
        }

        @Override
        @NotNull
        protected ListenableFuture<MultipleChunkResult<Map<String, RetainedMessage>>> persistenceCall(@NotNull ChunkCursor chunkCursor) {
            return this.retainedMessagePersistence.getAllLocalRetainedMessagesChunk(chunkCursor);
        }

        @Override
        @NotNull
        protected Collection<RetainedPublish> transform(@NotNull Map<String, RetainedMessage> stringRetainedMessageMap) {
            return stringRetainedMessageMap.entrySet().stream().map(entry -> new RetainedPublishImpl((String)entry.getKey(), (RetainedMessage)entry.getValue())).collect(Collectors.toUnmodifiableList());
        }
    }
}

