/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.metrics.ioc.provider;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.hivemq.metrics.HiveMQMetrics;
import com.hivemq.metrics.gauges.SessionsGauge;
import com.hivemq.persistence.local.ClientSessionLocalPersistence;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class SessionsGaugeProvider
implements Provider<SessionsGauge> {
    private final MetricRegistry metricRegistry;
    private final ClientSessionLocalPersistence clientSessionPersistence;

    @Inject
    public SessionsGaugeProvider(MetricRegistry metricRegistry, ClientSessionLocalPersistence clientSessionPersistence) {
        this.metricRegistry = metricRegistry;
        this.clientSessionPersistence = clientSessionPersistence;
    }

    @Singleton
    public SessionsGauge get() {
        SessionsGauge sessionsGauge = new SessionsGauge(this.clientSessionPersistence);
        this.metricRegistry.register(HiveMQMetrics.CLIENT_SESSIONS_CURRENT.name(), (Metric)sessionsGauge);
        return sessionsGauge;
    }
}

