/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.legacy;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.persistence.legacy.RetainedMessageItemCallback_4_4;
import com.hivemq.migration.persistence.legacy.serializer.RetainedMessageDeserializer_4_4;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.local.xodus.EnvironmentUtil;
import com.hivemq.persistence.local.xodus.XodusLocalPersistence;
import com.hivemq.persistence.local.xodus.XodusUtils;
import com.hivemq.persistence.local.xodus.bucket.Bucket;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.util.LocalPersistenceFileUtil;
import com.hivemq.util.ThreadPreConditions;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class RetainedMessageXodusLocalPersistence_4_4
extends XodusLocalPersistence {
    private static final Logger log = LoggerFactory.getLogger(RetainedMessageXodusLocalPersistence_4_4.class);
    public static final String PERSISTENCE_NAME = "retained_messages";
    public static final String PERSISTENCE_VERSION = "040000";
    @NotNull
    private final PublishPayloadPersistence payloadPersistence;
    private final AtomicLong retainMessageCounter = new AtomicLong(0L);

    @Inject
    public RetainedMessageXodusLocalPersistence_4_4(@NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull PublishPayloadPersistence payloadPersistence, @NotNull EnvironmentUtil environmentUtil, @NotNull PersistenceStartup persistenceStartup) {
        super(environmentUtil, localPersistenceFileUtil, persistenceStartup, InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get(), false);
        this.payloadPersistence = payloadPersistence;
    }

    @Override
    @NotNull
    protected String getName() {
        return PERSISTENCE_NAME;
    }

    @Override
    @NotNull
    protected String getVersion() {
        return PERSISTENCE_VERSION;
    }

    @Override
    @NotNull
    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITHOUT_DUPLICATES;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return log;
    }

    @Override
    @PostConstruct
    protected void postConstruct() {
        super.postConstruct();
    }

    @Override
    public void init() {
        try {
            for (Bucket bucket : this.buckets) {
                bucket.getEnvironment().executeInReadonlyTransaction(txn -> {
                    try (Cursor cursor = bucket.getStore().openCursor(txn);){
                        while (cursor.getNext()) {
                            this.retainMessageCounter.incrementAndGet();
                        }
                    }
                });
            }
        }
        catch (ExodusException e) {
            log.error("An error occurred while preparing the Retained Message persistence.");
            log.debug("Original Exception:", (Throwable)e);
            throw new UnrecoverableException(false);
        }
    }

    public long size() {
        return this.retainMessageCounter.get();
    }

    public void iterate(@NotNull RetainedMessageItemCallback_4_4 callback) {
        for (Bucket bucket : this.buckets) {
            bucket.getEnvironment().executeInReadonlyTransaction(txn -> {
                try (Cursor cursor = bucket.getStore().openCursor(txn);){
                    while (cursor.getNext()) {
                        RetainedMessage message = RetainedMessageDeserializer_4_4.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()));
                        String topic = RetainedMessageDeserializer_4_4.deserializeKey(XodusUtils.byteIterableToBytes(cursor.getKey()));
                        callback.onItem(topic, message);
                    }
                }
            });
        }
    }

    public void put(@NotNull RetainedMessage retainedMessage, @NotNull String topic, int bucketIndex) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkNotNull((Object)retainedMessage, (Object)"Retained message must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Bucket bucket = this.buckets[bucketIndex];
        bucket.getEnvironment().executeInExclusiveTransaction(txn -> {
            try (Cursor cursor = bucket.getStore().openCursor(txn);){
                ByteIterable byteIterable = cursor.getSearchKey(XodusUtils.bytesToByteIterable(RetainedMessageDeserializer_4_4.serializeKey(topic)));
                if (byteIterable != null) {
                    RetainedMessage retainedMessageFromStore = RetainedMessageDeserializer_4_4.deserializeValue(XodusUtils.byteIterableToBytes(cursor.getValue()));
                    log.trace("Replacing retained message for topic {}", (Object)topic);
                    bucket.getStore().put(txn, XodusUtils.bytesToByteIterable(RetainedMessageDeserializer_4_4.serializeKey(topic)), XodusUtils.bytesToByteIterable(RetainedMessageDeserializer_4_4.serializeValue(retainedMessage)));
                    this.payloadPersistence.decrementReferenceCounter(retainedMessageFromStore.getPublishId());
                } else {
                    bucket.getStore().put(txn, XodusUtils.bytesToByteIterable(RetainedMessageDeserializer_4_4.serializeKey(topic)), XodusUtils.bytesToByteIterable(RetainedMessageDeserializer_4_4.serializeValue(retainedMessage)));
                    log.trace("Creating new retained message for topic {}", (Object)topic);
                    this.retainMessageCounter.incrementAndGet();
                }
            }
        });
    }
}

