/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.persistence.queue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.migration.ValueMigration;
import com.hivemq.migration.logging.PayloadExceptionLogging;
import com.hivemq.migration.meta.MetaFileService;
import com.hivemq.migration.meta.MetaInformation;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.migration.persistence.legacy.ClientQueueXodusLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.PUBLISH_4_4;
import com.hivemq.migration.persistence.legacy.PublishPayloadLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.PublishPayloadRocksDBLocalPersistence_4_4;
import com.hivemq.migration.persistence.legacy.PublishPayloadXodusLocalPersistence_4_4;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.persistence.clientqueue.ClientQueueEntry;
import com.hivemq.persistence.clientqueue.ClientQueueXodusLocalPersistence;
import com.hivemq.persistence.clientsession.ClientSession;
import com.hivemq.persistence.local.ClientSessionLocalPersistence;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import com.hivemq.util.Exceptions;
import com.hivemq.util.LocalPersistenceFileUtil;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class ClientQueuePayloadIDMigration
implements ValueMigration {
    private static final Logger log = LoggerFactory.getLogger(ClientQueuePayloadIDMigration.class);
    private static final Logger migrationLog = LoggerFactory.getLogger((String)"migrations");
    private static final String FIRST_BUCKET_FOLDER = "client_queue_0";
    @NotNull
    private final Provider<ClientSessionLocalPersistence> sessionLocalPersistenceProvider;
    @NotNull
    private final Provider<ClientQueueXodusLocalPersistence> localXodusPersistenceProvider;
    @NotNull
    private final Provider<ClientQueueXodusLocalPersistence_4_4> clientQueueXodusLocalPersistence_4_4Provider;
    @NotNull
    private final Provider<PublishPayloadXodusLocalPersistence_4_4> publishPayloadXodusLocalPersistence_4_4Provider;
    @NotNull
    private final Provider<PublishPayloadRocksDBLocalPersistence_4_4> publishPayloadRocksDBLocalPersistence_4_4Provider;
    @NotNull
    private final LocalPersistenceFileUtil localPersistenceFileUtil;
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final PayloadExceptionLogging payloadExceptionLogging;
    private final int bucketCount;
    @NotNull
    private final AtomicReference<PersistenceType> previousPayloadType = new AtomicReference();

    @Inject
    public ClientQueuePayloadIDMigration(@NotNull Provider<ClientSessionLocalPersistence> sessionLocalPersistenceProvider, @NotNull Provider<ClientQueueXodusLocalPersistence> localXodusPersistenceProvider, @NotNull Provider<ClientQueueXodusLocalPersistence_4_4> clientQueueXodusLocalPersistence_4_4Provider, @NotNull Provider<PublishPayloadXodusLocalPersistence_4_4> publishPayloadXodusLocalPersistence_4_4Provider, @NotNull Provider<PublishPayloadRocksDBLocalPersistence_4_4> publishPayloadRocksDBLocalPersistence_4_4Provider, @NotNull LocalPersistenceFileUtil localPersistenceFileUtil, @NotNull SystemInformation systemInformation, @NotNull PayloadExceptionLogging payloadExceptionLogging) {
        this.sessionLocalPersistenceProvider = sessionLocalPersistenceProvider;
        this.localXodusPersistenceProvider = localXodusPersistenceProvider;
        this.clientQueueXodusLocalPersistence_4_4Provider = clientQueueXodusLocalPersistence_4_4Provider;
        this.publishPayloadXodusLocalPersistence_4_4Provider = publishPayloadXodusLocalPersistence_4_4Provider;
        this.publishPayloadRocksDBLocalPersistence_4_4Provider = publishPayloadRocksDBLocalPersistence_4_4Provider;
        this.localPersistenceFileUtil = localPersistenceFileUtil;
        this.systemInformation = systemInformation;
        this.bucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();
        this.payloadExceptionLogging = payloadExceptionLogging;
    }

    private static boolean oldFolderMissing(@NotNull File persistenceFolder) {
        File oldPersistenceFolder = new File(persistenceFolder, FIRST_BUCKET_FOLDER);
        if (!oldPersistenceFolder.exists()) {
            migrationLog.info("No (old) persistence folder (retained_messages) present, skipping migration.");
            log.debug("No (old) persistence folder (retained_messages) present, skipping migration.");
            return true;
        }
        return false;
    }

    @Override
    public void migrateToValue() {
        PublishPayloadLocalPersistence_4_4 legacyPayloadPersistence;
        MetaInformation metaFile = MetaFileService.readMetaFile(this.systemInformation);
        File persistenceFolder = this.localPersistenceFileUtil.getVersionedLocalPersistenceFolder("client_queue", "040000");
        if (ClientQueuePayloadIDMigration.oldFolderMissing(persistenceFolder)) {
            return;
        }
        if (metaFile.getPublishPayloadPersistenceType() == PersistenceType.FILE_NATIVE) {
            legacyPayloadPersistence = (PublishPayloadLocalPersistence_4_4)this.publishPayloadRocksDBLocalPersistence_4_4Provider.get();
            this.previousPayloadType.set(PersistenceType.FILE_NATIVE);
        } else {
            legacyPayloadPersistence = (PublishPayloadLocalPersistence_4_4)this.publishPayloadXodusLocalPersistence_4_4Provider.get();
            this.previousPayloadType.set(PersistenceType.FILE);
        }
        QueuedMessagePersistenceValueSwitchCallback iterationCallback = new QueuedMessagePersistenceValueSwitchCallback(this.bucketCount, (ClientQueueXodusLocalPersistence)this.localXodusPersistenceProvider.get(), this.payloadExceptionLogging, legacyPayloadPersistence, (ClientSessionLocalPersistence)this.sessionLocalPersistenceProvider.get());
        ((ClientQueueXodusLocalPersistence_4_4)this.clientQueueXodusLocalPersistence_4_4Provider.get()).iterate(iterationCallback);
    }

    public void closeLegacy() {
        if (this.previousPayloadType.get() == PersistenceType.FILE_NATIVE) {
            ((PublishPayloadRocksDBLocalPersistence_4_4)this.publishPayloadRocksDBLocalPersistence_4_4Provider.get()).closeDB();
        } else {
            ((PublishPayloadXodusLocalPersistence_4_4)this.publishPayloadXodusLocalPersistence_4_4Provider.get()).closeDB();
        }
        ((ClientQueueXodusLocalPersistence_4_4)this.clientQueueXodusLocalPersistence_4_4Provider.get()).closeDB();
    }

    @VisibleForTesting
    static class QueuedMessagePersistenceValueSwitchCallback
    implements ClientQueueXodusLocalPersistence_4_4.QueueCallback_4_4 {
        private final int bucketCount;
        @NotNull
        private final ClientQueueXodusLocalPersistence clientQueueXodusLocalPersistence;
        @NotNull
        private final PayloadExceptionLogging payloadExceptionLogging;
        @NotNull
        private final PublishPayloadLocalPersistence_4_4 legacyPayloadPersistence;
        @NotNull
        private final ClientSessionLocalPersistence sessionLocalPersistence;

        QueuedMessagePersistenceValueSwitchCallback(int bucketCount, @NotNull ClientQueueXodusLocalPersistence clientQueueXodusLocalPersistence, @NotNull PayloadExceptionLogging payloadExceptionLogging, @NotNull PublishPayloadLocalPersistence_4_4 legacyPayloadPersistence, @NotNull ClientSessionLocalPersistence sessionLocalPersistence) {
            this.bucketCount = bucketCount;
            this.clientQueueXodusLocalPersistence = clientQueueXodusLocalPersistence;
            this.payloadExceptionLogging = payloadExceptionLogging;
            this.legacyPayloadPersistence = legacyPayloadPersistence;
            this.sessionLocalPersistence = sessionLocalPersistence;
        }

        @Override
        public void onItem( @NotNull ClientQueuePersistenceImpl.Key key, @NotNull ImmutableList<ClientQueueEntry> messages) {
            try {
                ClientSession session;
                if (messages.isEmpty()) {
                    return;
                }
                int bucketIndex = BucketUtils.getBucket(key.getQueueId(), this.bucketCount);
                if (!key.isShared() && (session = this.sessionLocalPersistence.getSession(key.getQueueId(), true, false)) == null) {
                    return;
                }
                for (ClientQueueEntry queueEntry : messages) {
                    if (queueEntry.getMessageWithID() instanceof PUBLISH_4_4) {
                        PUBLISH_4_4 legacyPublish = (PUBLISH_4_4)queueEntry.getMessageWithID();
                        byte[] bytes = this.legacyPayloadPersistence.get(legacyPublish.getPayloadID());
                        if (bytes == null) {
                            this.payloadExceptionLogging.addLogging(legacyPublish.getPayloadID(), null, null);
                            continue;
                        }
                        legacyPublish.getPublish().setPayload(bytes);
                        this.clientQueueXodusLocalPersistence.add(key.getQueueId(), key.isShared(), legacyPublish.getPublish(), Long.MAX_VALUE, MqttConfigurationService.QueuedMessagesStrategy.DISCARD, queueEntry.isRetained(), bucketIndex);
                    }
                    if (!(queueEntry.getMessageWithID() instanceof PUBREL)) continue;
                    this.clientQueueXodusLocalPersistence.replace(key.getQueueId(), (PUBREL)queueEntry.getMessageWithID(), bucketIndex);
                }
            }
            catch (Throwable throwable) {
                log.warn("Could not migrate queued messages for queue id {}. Original exception: ", (Object)key.getQueueId(), (Object)throwable);
                Exceptions.rethrowError(throwable);
            }
        }
    }
}

